/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PartialBlockState
implements Predicate<BlockInWorld> {
    public static final PartialBlockState AIR = new PartialBlockState(Blocks.f_50016_.m_49966_(), Collections.emptyList(), null);
    public static final PartialBlockState ANY = new PartialBlockState(Blocks.f_50016_.m_49966_(), Collections.emptyList(), null){

        @Override
        public boolean test(BlockInWorld cachedBlockInfo) {
            return true;
        }

        @Override
        public String toString() {
            return "ANY";
        }
    };
    public static final PartialBlockState MACHINE = new PartialBlockState(Blocks.f_50016_.m_49966_(), Collections.emptyList(), null){

        @Override
        public boolean test(BlockInWorld cachedBlockInfo) {
            return cachedBlockInfo.m_61168_().m_60734_() instanceof CustomMachineBlock;
        }

        @Override
        public String toString() {
            return "MACHINE";
        }
    };
    public static final NamedCodec<PartialBlockState> CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        StringReader reader = new StringReader(s);
        try {
            BlockStateParser.BlockResult result = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)reader, (boolean)true);
            return DataResult.success((Object)new PartialBlockState(result.f_234748_(), Lists.newArrayList(result.f_234749_().keySet()), result.f_234750_()));
        }
        catch (CommandSyntaxException exception) {
            return DataResult.error(() -> ((CommandSyntaxException)exception).getMessage());
        }
    }, PartialBlockState::toString, "Partial block state");
    private final BlockState blockState;
    private final List<Property<?>> properties;
    private final CompoundTag nbt;

    public PartialBlockState(BlockState blockState, List<Property<?>> properties, CompoundTag nbt) {
        this.blockState = blockState;
        this.properties = properties;
        this.nbt = nbt;
    }

    public PartialBlockState(Block block) {
        this(block.m_49966_(), new ArrayList(), null);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public List<String> getProperties() {
        return this.properties.stream().map(property -> property.m_61708_() + "=" + this.blockState.m_61143_(property)).toList();
    }

    public CompoundTag getNbt() {
        return this.nbt;
    }

    public PartialBlockState rotate(Rotation rotation) {
        if (this.properties.contains(BlockStateProperties.f_61374_) && this.blockState.m_61138_((Property)BlockStateProperties.f_61374_) && !(this.blockState.m_60734_() instanceof CustomMachineBlock)) {
            Direction direction = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_);
            direction = rotation.m_55954_(direction);
            BlockState blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction);
            ArrayList properties = Lists.newArrayList(this.properties);
            if (!properties.contains(BlockStateProperties.f_61374_)) {
                properties.add(BlockStateProperties.f_61374_);
            }
            return new PartialBlockState(blockState, properties, this.nbt);
        }
        if (this.properties.contains(BlockStateProperties.f_61372_) && this.blockState.m_61138_((Property)BlockStateProperties.f_61372_) && !(this.blockState.m_60734_() instanceof CustomMachineBlock)) {
            Direction direction = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
            if (direction.m_122434_() == Direction.Axis.Y) {
                return this;
            }
            direction = rotation.m_55954_(direction);
            BlockState blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction);
            ArrayList properties = Lists.newArrayList(this.properties);
            if (!properties.contains(BlockStateProperties.f_61372_)) {
                properties.add(BlockStateProperties.f_61372_);
            }
            return new PartialBlockState(blockState, properties, this.nbt);
        }
        return this;
    }

    @Override
    public boolean test(BlockInWorld cachedBlockInfo) {
        BlockState blockstate = cachedBlockInfo.m_61168_();
        if (!blockstate.m_60713_(this.blockState.m_60734_())) {
            return false;
        }
        for (Property<?> property : this.properties) {
            if (blockstate.m_61143_(property) == this.blockState.m_61143_(property)) continue;
            return false;
        }
        if (this.nbt == null) {
            return true;
        }
        BlockEntity tileentity = cachedBlockInfo.m_61174_();
        return tileentity != null && NbtUtils.m_129235_((Tag)this.nbt, (Tag)tileentity.m_187480_(), (boolean)true);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(BuiltInRegistries.f_256975_.m_7981_((Object)this.blockState.m_60734_()));
        if (!this.properties.isEmpty()) {
            builder.append("[");
        }
        Iterator<Property<?>> iterator = this.properties.iterator();
        while (iterator.hasNext()) {
            Property<?> property = iterator.next();
            Comparable value = this.blockState.m_61143_(property);
            builder.append(property.m_61708_());
            builder.append("=");
            builder.append(value);
            if (iterator.hasNext()) {
                builder.append(",");
                continue;
            }
            builder.append("]");
        }
        if (this.nbt != null && !this.nbt.m_128456_()) {
            builder.append(this.nbt);
        }
        return builder.toString();
    }

    public MutableComponent getName() {
        return this.blockState.m_60734_().m_49954_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartialBlockState)) {
            return false;
        }
        PartialBlockState other = (PartialBlockState)o;
        if (this.blockState != other.blockState) {
            return false;
        }
        if (!new HashSet(this.properties).containsAll(other.properties) || !new HashSet(other.properties).containsAll(this.properties)) {
            return false;
        }
        return NbtUtils.m_129235_((Tag)this.nbt, (Tag)other.nbt, (boolean)true);
    }
}

