/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MachineShape
implements Function<Direction, VoxelShape> {
    private static final NamedCodec<List<AABB>> BOX_CODEC = DefaultCodecs.BOX.listOf();
    private static final NamedCodec<Map<Direction, List<AABB>>> MAP_CODEC = NamedCodec.unboundedMap(DefaultCodecs.DIRECTION, BOX_CODEC, "Map<Direction, List<Box>>");
    public static final NamedCodec<MachineShape> CODEC = new NamedCodec<MachineShape>(){

        @Override
        public <T> DataResult<Pair<MachineShape, T>> decode(DynamicOps<T> ops, T input) {
            DataResult<PartialBlockState> block = PartialBlockState.CODEC.read(ops, input);
            if (block.result().isPresent()) {
                BlockState state = ((PartialBlockState)block.result().get()).getBlockState();
                EnumMap shapes = Maps.newEnumMap(Direction.class);
                try {
                    for (Direction side2 : Direction.values()) {
                        shapes.put(side2, state.m_60808_(null, null));
                    }
                }
                catch (Exception e) {
                    return DataResult.error(() -> "Can't mimic shape of block: " + block.result().get());
                }
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            DataResult<List<AABB>> boxes = BOX_CODEC.read(ops, input);
            if (boxes.result().isPresent()) {
                VoxelShape shape = MachineShape.fromAABBList((List)boxes.result().get());
                EnumMap shapes = Maps.newEnumMap(Direction.class);
                for (Direction side3 : Direction.values()) {
                    if (side3.m_122434_() == Direction.Axis.Y) continue;
                    shapes.put(side3, MachineShape.rotateShape(Direction.NORTH, side3, shape));
                }
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            DataResult<Map<Direction, List<AABB>>> map = MAP_CODEC.read(ops, input);
            if (map.result().isPresent()) {
                EnumMap shapes = Maps.newEnumMap(Direction.class);
                ((Map)map.result().get()).forEach((side, box) -> shapes.put(side, MachineShape.fromAABBList(box)));
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            return DataResult.error(() -> "Can't parse block shape: " + input);
        }

        @Override
        public <T> DataResult<T> encode(DynamicOps<T> ops, MachineShape input, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            input.shapes.forEach((side, shape) -> builder.add(side.m_122433_(), BOX_CODEC.encodeStart(ops, shape.m_83299_())));
            return builder.build(prefix);
        }

        @Override
        public String name() {
            return "Machine Shape";
        }
    };
    public static final MachineShape DEFAULT = new MachineShape();
    public static final MachineShape DEFAULT_COLLISION = new MachineShape();
    private final Map<Direction, VoxelShape> shapes = Maps.newEnumMap(Direction.class);

    public MachineShape() {
        for (Direction side : Direction.values()) {
            this.shapes.put(side, Shapes.m_83144_());
        }
    }

    public MachineShape(Map<Direction, VoxelShape> shapes) {
        this.shapes.putAll(shapes);
    }

    @Override
    public VoxelShape apply(Direction side) {
        return this.shapes.get(side);
    }

    private static VoxelShape fromAABBList(List<AABB> list) {
        VoxelShape shape = Shapes.m_83040_();
        for (AABB box : list) {
            VoxelShape partial = Shapes.m_83064_((AABB)box);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)partial, (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    private static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }
}

