/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class LootTableHelper {
    private static final List<ResourceLocation> tables = new ArrayList<ResourceLocation>();
    private static Map<ResourceLocation, List<Pair<ItemStack, Double>>> lootsMap = new HashMap<ResourceLocation, List<Pair<ItemStack, Double>>>();

    public static void addTable(ResourceLocation table) {
        if (!tables.contains(table)) {
            tables.add(table);
        }
    }

    public static void generate(MinecraftServer server) {
        lootsMap.clear();
        LootParams params = new LootParams.Builder(server.m_129783_()).m_287235_(Registration.CUSTOM_MACHINE_LOOT_PARAMETER_SET);
        LootContext context = new LootContext.Builder(params).m_287259_(null);
        for (ResourceLocation table : tables) {
            List<Pair<ItemStack, Double>> loots = LootTableHelper.getLoots(table, server, context);
            lootsMap.put(table, loots);
        }
    }

    private static List<Pair<ItemStack, Double>> getLoots(ResourceLocation table, MinecraftServer server, LootContext context) {
        ArrayList<Pair<ItemStack, Double>> loots = new ArrayList<Pair<ItemStack, Double>>();
        LootTable lootTable = server.m_278653_().m_278676_(table);
        BiFunction globalFunction = lootTable.f_79111_;
        List<LootPool> pools = PlatformHelper.getPoolsFromTable(lootTable);
        if (pools == null) {
            return Collections.emptyList();
        }
        for (LootPool pool : pools) {
            LootPoolEntryContainer[] entries = pool.f_79023_;
            float total = Arrays.stream(entries).filter(entry -> entry instanceof LootPoolSingletonContainer).mapToInt(entry -> ((LootPoolSingletonContainer)entry).f_79675_).sum();
            Arrays.stream(entries).filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).forEach(entry -> {
                Consumer<ItemStack> consumer = stack -> loots.add(Pair.of((Object)stack, (Object)((float)entry.f_79675_ / total)));
                consumer = LootTableHelper.applyFunctions(consumer, entry.f_79677_, globalFunction, context);
                entry.m_6948_(consumer, context);
            });
            Arrays.stream(entries).filter(entry -> entry instanceof TagEntry).map(entry -> (TagEntry)entry).forEach(entry -> {
                Consumer<ItemStack> consumer = stack -> loots.add(Pair.of((Object)stack, (Object)((float)entry.f_79675_ / total / (float)(entry.f_79822_ ? TagUtil.getItems((TagKey<Item>)entry.f_79821_).count() : 1L))));
                consumer = LootTableHelper.applyFunctions(consumer, entry.f_79677_, globalFunction, context);
                entry.m_6948_(consumer, context);
            });
            Arrays.stream(entries).filter(entry -> entry instanceof LootTableReference).map(entry -> (LootTableReference)entry).map(entry -> LootTableHelper.getLoots(entry.f_79754_, server, context)).forEach(loots::addAll);
        }
        return loots;
    }

    private static Consumer<ItemStack> applyFunctions(Consumer<ItemStack> consumer, LootItemFunction[] functions, BiFunction<ItemStack, LootContext, ItemStack> globalFunction, LootContext context) {
        for (LootItemFunction function : functions) {
            consumer = LootItemFunction.m_80724_((BiFunction)function, consumer, (LootContext)context);
        }
        return LootItemFunction.m_80724_(globalFunction, consumer, (LootContext)context);
    }

    public static Map<ResourceLocation, List<Pair<ItemStack, Double>>> getLoots() {
        return lootsMap;
    }

    public static void receiveLoots(Map<ResourceLocation, List<Pair<ItemStack, Double>>> newLoots) {
        lootsMap = newLoots;
    }

    public static List<Pair<ItemStack, Double>> getLootsForTable(ResourceLocation table) {
        return lootsMap.getOrDefault(table, Collections.emptyList());
    }
}

