/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.integration.config.CMConfig;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.network.SUpdateMachinesPacket;
import fr.frinn.custommachinery.common.util.MachineJsonOps;
import fr.frinn.custommachinery.common.util.MachineList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FileUtils {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void writeNewMachineJson(MinecraftServer server, CustomMachine machine, boolean kubejs) {
        if (kubejs && !Platform.isModLoaded((String)"kubejs")) {
            CustomMachinery.LOGGER.error("Can't write new machine json {} in kubejs data folder because KubeJS isn't present", (Object)machine.getId());
            return;
        }
        DataResult result = CustomMachine.CODEC.encodeStart(JsonOps.INSTANCE, machine);
        if (result.error().isPresent()) {
            CustomMachinery.LOGGER.error("Can't write new machine json: {}\n{}", (Object)machine.getId().m_135815_(), (Object)((DataResult.PartialResult)result.error().get()).message());
            return;
        }
        if (result.result().isPresent()) {
            JsonElement json = (JsonElement)result.result().get();
            Object root = server.m_6237_().getAbsolutePath();
            if (((String)root).endsWith(File.separator + ".")) {
                root = ((String)root).substring(0, ((String)root).length() - 2);
            }
            if (kubejs) {
                root = (String)root + File.separator + "kubejs" + File.separator + "data" + File.separator + machine.getId().m_135827_() + File.separator + "machines";
            } else if (!CMConfig.get().defaultNewMachinePath.isEmpty()) {
                root = (String)root + (CMConfig.get().defaultNewMachinePath.startsWith("/") ? "" : File.separator) + CMConfig.get().defaultNewMachinePath.replaceFirst("./", "");
            }
            File file = new File((String)root, machine.getId().m_135815_() + ".json");
            CustomMachinery.LOGGER.info("Writing new machine: {} in {}", (Object)machine.getLocation().getId(), (Object)file.getPath());
            try {
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    CustomMachinery.LOGGER.error("Can't create directory for '{}'", (Object)file.getParentFile().getAbsolutePath());
                }
                if (file.exists() || file.createNewFile()) {
                    JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(file));
                    GSON.toJson(json, writer);
                    writer.close();
                    if (kubejs) {
                        CustomMachinery.MACHINES.put(machine.getId(), machine);
                        MachineList.setNeedRefresh();
                        new SUpdateMachinesPacket(CustomMachinery.MACHINES).sendToAll(server);
                    }
                } else {
                    CustomMachinery.LOGGER.error("Can't write new machine file in '{}'", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                CustomMachinery.LOGGER.error("Error while writing new machine to file: {}\n{}\n{}", (Object)file.getAbsolutePath(), (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public static void writeMachineJson(MinecraftServer server, CustomMachine machine) {
        MachineLocation location = machine.getLocation();
        File machineJson = location.getFile(server);
        if (machineJson == null) {
            CustomMachinery.LOGGER.error("Error while editing machine: {}\nCan't edit machine loaded with {}", (Object)location.getId(), (Object)location.getLoader().toString());
            return;
        }
        if (!machineJson.exists() || machineJson.isDirectory()) {
            CustomMachinery.LOGGER.error("Error while editing machine: {}\nFile '{}' doesn't exist", (Object)location.getId(), (Object)machineJson.getAbsolutePath());
            return;
        }
        try (JsonWriter writer = GSON.newJsonWriter((Writer)new FileWriter(machineJson));){
            DataResult result = CustomMachine.CODEC.encodeStart(MachineJsonOps.INSTANCE, machine);
            if (result.error().isPresent()) {
                CustomMachinery.LOGGER.error("Can't edit machine json: {}\n{}", (Object)machine.getId().m_135815_(), (Object)((DataResult.PartialResult)result.error().get()).message());
                return;
            }
            if (result.result().isPresent()) {
                JsonElement json = (JsonElement)result.result().get();
                GSON.toJson(json, writer);
                CustomMachinery.LOGGER.info("Successfully edited machine: {} at location '{}'", (Object)location.getId(), (Object)machineJson.getAbsolutePath());
            }
        }
        catch (IOException e) {
            CustomMachinery.LOGGER.error("Error while editing machine to file: {}\n{}\n{}", (Object)machineJson.getAbsolutePath(), (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void deleteMachineJson(MinecraftServer server, MachineLocation location) {
        File machineJson = location.getFile(server);
        if (machineJson == null) {
            CustomMachinery.LOGGER.error("Error while deleting machine: {}\nCan't delete machine loaded with {}", (Object)location.getId(), (Object)location.getLoader().toString());
            return;
        }
        if (!machineJson.exists() || machineJson.isDirectory()) {
            CustomMachinery.LOGGER.error("Error while deleting machine: {}\nFile '{}' doesn't exist", (Object)location.getId(), (Object)machineJson.getAbsolutePath());
            return;
        }
        if (!machineJson.delete()) {
            CustomMachinery.LOGGER.error("Error while deleting machine: {}\nFile '{}' can't be deleted", (Object)location.getId(), (Object)machineJson.getAbsolutePath());
            return;
        }
        CustomMachinery.LOGGER.info("Successfully deleted machine: {} at location '{}'", (Object)location.getId(), (Object)machineJson.getAbsolutePath());
    }
}

