/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BlockStructure {
    private final Map<BlockPos, IIngredient<PartialBlockState>> blocks_north;
    private final Map<BlockPos, IIngredient<PartialBlockState>> blocks_east;
    private final Map<BlockPos, IIngredient<PartialBlockState>> blocks_south;
    private final Map<BlockPos, IIngredient<PartialBlockState>> blocks_west;

    public BlockStructure(Map<BlockPos, IIngredient<PartialBlockState>> blocks) {
        this.blocks_south = blocks;
        this.blocks_west = this.rotate(blocks, Rotation.CLOCKWISE_90);
        this.blocks_north = this.rotate(blocks, Rotation.CLOCKWISE_180);
        this.blocks_east = this.rotate(blocks, Rotation.COUNTERCLOCKWISE_90);
    }

    public Map<BlockPos, IIngredient<PartialBlockState>> getBlocks(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> this.blocks_south;
            case Direction.EAST -> this.blocks_east;
            case Direction.WEST -> this.blocks_west;
            default -> this.blocks_north;
        };
    }

    public boolean match(LevelReader world, BlockPos machinePos, Direction machineFacing) {
        Map<BlockPos, IIngredient<PartialBlockState>> blocks = this.getBlocks(machineFacing);
        BlockPos.MutableBlockPos worldPos = new BlockPos.MutableBlockPos();
        for (BlockPos pos : blocks.keySet()) {
            IIngredient<PartialBlockState> ingredient = blocks.get(pos);
            worldPos.m_122178_(pos.m_123341_() + machinePos.m_123341_(), pos.m_123342_() + machinePos.m_123342_(), pos.m_123343_() + machinePos.m_123343_());
            BlockInWorld info = new BlockInWorld(world, (BlockPos)worldPos, false);
            if (!ingredient.getAll().stream().noneMatch(state -> state.test(info))) continue;
            return false;
        }
        return true;
    }

    private Map<BlockPos, IIngredient<PartialBlockState>> rotate(Map<BlockPos, IIngredient<PartialBlockState>> blocks, Rotation rotation) {
        HashMap<BlockPos, IIngredient<PartialBlockState>> rotated = new HashMap<BlockPos, IIngredient<PartialBlockState>>();
        blocks.forEach((pos, ingredient) -> {
            if (ingredient instanceof BlockIngredient) {
                rotated.put(pos.m_7954_(rotation), new BlockIngredient(((PartialBlockState)ingredient.getAll().get(0)).rotate(rotation)));
            } else {
                rotated.put(pos.m_7954_(rotation), (IIngredient<PartialBlockState>)ingredient);
            }
        });
        return rotated;
    }

    public static class Builder {
        private static final Joiner COMMA_JOIN = Joiner.on((String)",");
        private final List<String[]> depth = Lists.newArrayList();
        private final Map<Character, IIngredient<PartialBlockState>> symbolMap = Maps.newHashMap();
        private int aisleHeight;
        private int rowWidth;

        private Builder() {
            this.symbolMap.put(Character.valueOf(' '), BlockIngredient.ANY);
            this.symbolMap.put(Character.valueOf('m'), BlockIngredient.MACHINE);
        }

        public Builder aisle(String ... aisle) {
            if (!ArrayUtils.isEmpty((Object[])aisle) && !StringUtils.isEmpty((CharSequence)aisle[0])) {
                if (this.depth.isEmpty()) {
                    this.aisleHeight = aisle.length;
                    this.rowWidth = aisle[0].length();
                }
                if (aisle.length != this.aisleHeight) {
                    throw new IllegalArgumentException("Expected aisle with height of " + this.aisleHeight + ", but was given one with a height of " + aisle.length + ")");
                }
                for (String s : aisle) {
                    if (s.length() != this.rowWidth) {
                        throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.rowWidth + ", found one with " + s.length() + ")");
                    }
                    for (char c0 : s.toCharArray()) {
                        if (this.symbolMap.containsKey(Character.valueOf(c0))) continue;
                        this.symbolMap.put(Character.valueOf(c0), null);
                    }
                }
                this.depth.add(aisle);
                return this;
            }
            throw new IllegalArgumentException("Empty pattern for aisle");
        }

        public static Builder start() {
            return new Builder();
        }

        public Builder where(char symbol, IIngredient<PartialBlockState> blockMatcher) {
            this.symbolMap.put(Character.valueOf(symbol), blockMatcher);
            return this;
        }

        public BlockStructure build() {
            this.checkMissingPredicates();
            BlockPos machinePos = this.getMachinePos();
            HashMap<BlockPos, IIngredient<PartialBlockState>> blocks = new HashMap<BlockPos, IIngredient<PartialBlockState>>();
            for (int i = 0; i < this.depth.size(); ++i) {
                for (int j = 0; j < this.aisleHeight; ++j) {
                    for (int k = 0; k < this.rowWidth; ++k) {
                        blocks.put(new BlockPos(k - machinePos.m_123341_(), i - machinePos.m_123342_(), j - machinePos.m_123343_()), this.symbolMap.get(Character.valueOf(this.depth.get(i)[j].charAt(k))));
                    }
                }
            }
            return new BlockStructure(blocks);
        }

        private BlockPos getMachinePos() {
            BlockPos machinePos = null;
            for (int i = 0; i < this.depth.size(); ++i) {
                for (int j = 0; j < this.aisleHeight; ++j) {
                    for (int k = 0; k < this.rowWidth; ++k) {
                        if (this.depth.get(i)[j].charAt(k) != 'm') continue;
                        if (machinePos == null) {
                            machinePos = new BlockPos(k, i, j);
                            continue;
                        }
                        throw new IllegalStateException("The structure pattern need exactly one 'm' character to defined the machine position, several found !");
                    }
                }
            }
            if (machinePos != null) {
                return machinePos;
            }
            throw new IllegalStateException("You need to define the machine position in the structure with character 'm'");
        }

        private void checkMissingPredicates() {
            ArrayList list = Lists.newArrayList();
            for (Map.Entry<Character, IIngredient<PartialBlockState>> entry : this.symbolMap.entrySet()) {
                if (entry.getValue() != null) continue;
                list.add(entry.getKey());
            }
            if (!list.isEmpty()) {
                throw new IllegalStateException("Blocks for character(s) " + COMMA_JOIN.join((Iterable)list) + " are missing");
            }
        }
    }
}

