/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.upgrade.modifier;

import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import java.io.Serializable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class SpeedRecipeModifier
extends RecipeModifier {
    private final IRecipeModifier.OPERATION operation;

    public SpeedRecipeModifier(IRecipeModifier.OPERATION operation, double modifier, double chance, double max, double min, @Nullable Component tooltip) {
        super((RequirementType)Registration.SPEED_REQUIREMENT.get(), RequirementIOMode.INPUT, modifier, "", chance, max, min, tooltip);
        this.operation = operation;
    }

    @Override
    public boolean shouldApply(RequirementType<?> type, RequirementIOMode mode, @Nullable String target) {
        return type == this.requirementType && (this.target.isEmpty() || this.target.equals(target)) && this.chance > RAND.nextDouble();
    }

    @Override
    public double apply(double original, int upgradeAmount) {
        double modified = switch (this.operation) {
            default -> throw new IncompatibleClassChangeError();
            case IRecipeModifier.OPERATION.ADDITION -> original + this.modifier * (double)upgradeAmount;
            case IRecipeModifier.OPERATION.MULTIPLICATION -> original * this.modifier * (double)upgradeAmount;
            case IRecipeModifier.OPERATION.EXPONENTIAL -> original * Math.pow(this.modifier, upgradeAmount);
        };
        return Mth.m_14008_((double)modified, (double)this.min, (double)this.max);
    }

    @Override
    public Component getDefaultTooltip() {
        double tooltipModifier = this.operation == IRecipeModifier.OPERATION.ADDITION ? this.modifier : this.modifier * 100.0 - 100.0;
        String tooltip = (tooltipModifier >= 0.0 ? "+" : "") + (Serializable)(this.operation == IRecipeModifier.OPERATION.ADDITION ? Double.valueOf(tooltipModifier) : tooltipModifier + "%") + " " + this.requirementType.getName().getString();
        return Component.m_237113_((String)tooltip);
    }

    @Override
    public IRecipeModifier.OPERATION getOperation() {
        return this.operation;
    }
}

