/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.RedstoneMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinery.impl.util.IntRange;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;

public class RedstoneRequirement
extends AbstractRequirement<RedstoneMachineComponent>
implements ITickableRequirement<RedstoneMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<RedstoneRequirement> CODEC = NamedCodec.record(redstoneRequirementInstance -> redstoneRequirementInstance.group(IntRange.CODEC.fieldOf("power").forGetter(requirement -> requirement.powerLevel)).apply((Applicative)redstoneRequirementInstance, RedstoneRequirement::new), "Redstone requirement");
    private final IntRange powerLevel;

    public RedstoneRequirement(IntRange powerLevel) {
        super(RequirementIOMode.INPUT);
        this.powerLevel = powerLevel;
    }

    @Override
    public RequirementType<RedstoneRequirement> getType() {
        return (RequirementType)Registration.REDSTONE_REQUIREMENT.get();
    }

    @Override
    public boolean test(RedstoneMachineComponent component, ICraftingContext context) {
        return this.powerLevel.contains(component.getMachinePower());
    }

    @Override
    public CraftingResult processStart(RedstoneMachineComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.redstone.error", (Object[])new Object[]{this.powerLevel.toFormattedString()}));
    }

    @Override
    public CraftingResult processEnd(RedstoneMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<RedstoneMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.REDSTONE_MACHINE_COMPONENT.get();
    }

    @Override
    public CraftingResult processTick(RedstoneMachineComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.redstone.error", (Object[])new Object[]{this.powerLevel.toFormattedString()}));
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.redstone.info", (Object[])new Object[]{this.powerLevel.toFormattedString()})).setItemIcon(Items.f_42451_);
    }
}

