/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.ItemIngredientWrapper;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.requirement.AbstractChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DurabilityRequirement
extends AbstractChanceableRequirement<ItemComponentHandler>
implements IJEIIngredientRequirement<ItemStack> {
    public static final NamedCodec<DurabilityRequirement> CODEC = NamedCodec.record(durabilityRequirementInstance -> durabilityRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), IIngredient.ITEM.fieldOf("item").forGetter(requirement -> requirement.item), NamedCodec.intRange(1, Integer.MAX_VALUE).fieldOf("amount").forGetter(requirement -> requirement.amount), DefaultCodecs.COMPOUND_TAG.optionalFieldOf("nbt").forGetter(requirement -> Optional.ofNullable(requirement.nbt)), NamedCodec.BOOL.optionalFieldOf("break", false).forGetter(requirement -> requirement.canBreak), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractChanceableRequirement::getChance), NamedCodec.STRING.optionalFieldOf("slot", "").forGetter(requirement -> requirement.slot)).apply((Applicative)durabilityRequirementInstance, (mode, item, amount, nbt, canBreak, chance, slot) -> {
        DurabilityRequirement requirement = new DurabilityRequirement((RequirementIOMode)((Object)((Object)mode)), (IIngredient<Item>)item, (int)amount, nbt.orElse(null), (boolean)canBreak, (String)slot);
        requirement.setChance((double)chance);
        return requirement;
    }), "Durability requirement");
    private final IIngredient<Item> item;
    private final int amount;
    private final CompoundTag nbt;
    private final String slot;
    private final boolean canBreak;

    public DurabilityRequirement(RequirementIOMode mode, IIngredient<Item> item, int amount, @Nullable CompoundTag nbt, boolean canBreak, String slot) {
        super(mode);
        this.item = item;
        this.amount = amount;
        this.nbt = nbt;
        this.canBreak = canBreak;
        this.slot = slot;
    }

    @Override
    public RequirementType<DurabilityRequirement> getType() {
        return (RequirementType)Registration.DURABILITY_REQUIREMENT.get();
    }

    @Override
    public boolean test(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return this.item.getAll().stream().mapToInt(item -> component.getDurabilityAmount(this.slot, (Item)item, this.nbt)).sum() >= amount;
        }
        return this.item.getAll().stream().mapToInt(item -> component.getSpaceForDurability(this.slot, (Item)item, this.nbt)).sum() >= amount;
    }

    @Override
    public CraftingResult processStart(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            int maxRemove = this.item.getAll().stream().mapToInt(item -> component.getDurabilityAmount(this.slot, (Item)item, this.nbt)).sum();
            if (maxRemove >= amount) {
                int toDamage = amount;
                for (Item item2 : this.item.getAll()) {
                    int canDamage = component.getDurabilityAmount(this.slot, item2, this.nbt);
                    if (canDamage <= 0) continue;
                    canDamage = Math.min(canDamage, toDamage);
                    component.removeDurability(this.slot, item2, canDamage, this.nbt, this.canBreak);
                    if ((toDamage -= canDamage) != 0) continue;
                    return CraftingResult.success();
                }
            }
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.durability.error.input", (Object[])new Object[]{this.item, amount, maxRemove}));
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.OUTPUT) {
            int maxRepair = this.item.getAll().stream().mapToInt(item -> component.getSpaceForDurability(this.slot, (Item)item, this.nbt)).sum();
            if (maxRepair >= amount) {
                int toRepair = amount;
                for (Item item2 : this.item.getAll()) {
                    int canRepair = component.getSpaceForDurability(this.slot, item2, this.nbt);
                    if (canRepair <= 0) continue;
                    canRepair = Math.min(canRepair, toRepair);
                    component.repairItem(this.slot, item2, canRepair, this.nbt);
                    if ((toRepair -= canRepair) != 0) continue;
                    return CraftingResult.success();
                }
            }
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.durability.error.output", (Object[])new Object[]{this.item, amount, maxRepair}));
        }
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType getComponentType() {
        return (MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public List<IJEIIngredientWrapper<ItemStack>> getJEIIngredientWrappers(IMachineRecipe recipe) {
        return Collections.singletonList(new ItemIngredientWrapper(this.getMode(), this.item, this.amount, this.getChance(), true, this.nbt, this.slot, true));
    }
}

