/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.IDelayedRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.DropMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class DropRequirement
extends AbstractDelayedChanceableRequirement<DropMachineComponent>
implements ITickableRequirement<DropMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<DropRequirement> CODEC = NamedCodec.record(dropRequirementInstance -> dropRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(IRequirement::getMode), Action.CODEC.fieldOf("action").forGetter(requirement -> requirement.action), IIngredient.ITEM.listOf().optionalFieldOf("input", Collections.emptyList()).forGetter(requirement -> requirement.input), NamedCodec.BOOL.optionalFieldOf("whitelist", true).forGetter(requirement -> requirement.whitelist), RegistrarCodec.ITEM.optionalFieldOf("output", Items.f_41852_).forGetter(requirement -> requirement.output), DefaultCodecs.COMPOUND_TAG.optionalFieldOf("nbt").forGetter(requirement -> Optional.ofNullable(requirement.nbt)), NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("amount", 1).forGetter(requirement -> requirement.amount), NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("radius", 1).forGetter(requirement -> requirement.radius), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("delay", 0.0).forGetter(IDelayedRequirement::getDelay)).apply((Applicative)dropRequirementInstance, (mode, action, input, whitelist, output, nbt, amount, radius, chance, delay) -> {
        DropRequirement requirement = new DropRequirement((RequirementIOMode)((Object)((Object)mode)), (Action)((Object)((Object)action)), (List<IIngredient<Item>>)input, (boolean)whitelist, (Item)output, nbt.orElse(null), (int)amount, (int)radius);
        requirement.setChance((double)chance);
        requirement.setDelay((double)delay);
        return requirement;
    }), "Drop requirement");
    private final Action action;
    private final List<IIngredient<Item>> input;
    private final boolean whitelist;
    private final Item output;
    @Nullable
    private final CompoundTag nbt;
    private final int amount;
    private final int radius;

    public DropRequirement(RequirementIOMode mode, Action action, List<IIngredient<Item>> input, boolean whitelist, Item output, @Nullable CompoundTag nbt, int amount, int radius) {
        super(mode);
        this.action = action;
        if ((action == Action.CHECK || action == Action.CONSUME) && input.isEmpty()) {
            throw new IllegalArgumentException("Drop requirement in" + action + "  mode MUST have at least one input item ingredient !");
        }
        this.input = input;
        this.whitelist = whitelist;
        if (action == Action.PRODUCE && output == Items.f_41852_) {
            throw new IllegalArgumentException("Drop requirement in " + action + " mode MUST have an output item specified !");
        }
        this.output = output;
        this.nbt = nbt;
        this.amount = amount;
        this.radius = radius;
    }

    @Override
    public RequirementType<DropRequirement> getType() {
        return (RequirementType)Registration.DROP_REQUIREMENT.get();
    }

    @Override
    public boolean test(DropMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.action == Action.CHECK || this.action == Action.CONSUME) {
            return component.getItemAmount(this.input, this.radius, this.whitelist) >= amount;
        }
        return true;
    }

    @Override
    public CraftingResult processStart(DropMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0 || this.getMode() != RequirementIOMode.INPUT) {
            return CraftingResult.pass();
        }
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        int radius = (int)context.getModifiedValue(this.radius, this, "radius");
        switch (this.action) {
            case CONSUME: {
                int found = component.getItemAmount(this.input, radius, this.whitelist);
                if (found >= amount) {
                    component.consumeItem(this.input, amount, radius, this.whitelist);
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.drop.error.input", (Object[])new Object[]{amount, found}));
            }
            case PRODUCE: {
                ItemStack stack = Utils.makeItemStack(this.output, amount, this.nbt);
                if (component.produceItem(stack)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.drop.error.input", (Object[])new Object[]{Component.m_237113_((String)(amount + "x")).m_7220_((Component)Component.m_237115_((String)this.output.m_5671_(stack)))}));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(DropMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0 || this.getMode() != RequirementIOMode.OUTPUT) {
            return CraftingResult.pass();
        }
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        int radius = (int)context.getModifiedValue(this.radius, this, "radius");
        switch (this.action) {
            case CONSUME: {
                int found = component.getItemAmount(this.input, radius, this.whitelist);
                if (found > amount) {
                    component.consumeItem(this.input, amount, radius, this.whitelist);
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.drop.error.input", (Object[])new Object[]{amount, found}));
            }
            case PRODUCE: {
                ItemStack stack = Utils.makeItemStack(this.output, amount, this.nbt);
                if (component.produceItem(stack)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.drop.error.input", (Object[])new Object[]{Component.m_237113_((String)(amount + "x")).m_7220_((Component)Component.m_237115_((String)this.output.m_5671_(stack)))}));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<DropMachineComponent> getComponentType() {
        return (MachineComponentType)Registration.DROP_MACHINE_COMPONENT.get();
    }

    @Override
    public CraftingResult processTick(DropMachineComponent component, ICraftingContext context) {
        if (this.action == Action.CHECK) {
            int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
            int radius = (int)context.getModifiedValue(this.radius, this, "radius");
            int found = component.getItemAmount(this.input, radius, this.whitelist);
            if (found >= amount) {
                return CraftingResult.success();
            }
            return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.drop.error.input", (Object[])new Object[]{amount, found}));
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult execute(DropMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        int radius = (int)context.getModifiedValue(this.radius, this, "radius");
        switch (this.action) {
            case CONSUME: {
                int found = component.getItemAmount(this.input, radius, this.whitelist);
                if (found > amount) {
                    component.consumeItem(this.input, amount, radius, this.whitelist);
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.drop.error.input", (Object[])new Object[]{amount, found}));
            }
            case PRODUCE: {
                ItemStack stack = Utils.makeItemStack(this.output, amount, this.nbt);
                if (component.produceItem(stack)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((Component)Component.m_237110_((String)"custommachinery.requirements.drop.error.output", (Object[])new Object[]{Component.m_237113_((String)(amount + "x")).m_7220_((Component)Component.m_237115_((String)this.output.m_5671_(stack)))}));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        switch (this.action) {
            case CHECK: {
                info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.drop.info.check", (Object[])new Object[]{this.amount, this.radius}));
                info.addTooltip((Component)Component.m_237115_((String)("custommachinery.requirements.drop.info." + (this.whitelist ? "whitelist" : "blacklist"))).m_130940_(this.whitelist ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
                this.input.forEach(ingredient -> info.addTooltip((Component)Component.m_237113_((String)ingredient.toString())));
                info.setItemIcon(Items.f_41968_);
                break;
            }
            case CONSUME: {
                info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.drop.info.consume", (Object[])new Object[]{this.amount, this.radius}));
                info.addTooltip((Component)Component.m_237115_((String)("custommachinery.requirements.drop.info." + (this.whitelist ? "whitelist" : "blacklist"))).m_130940_(this.whitelist ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
                this.input.forEach(ingredient -> info.addTooltip((Component)Component.m_237113_((String)("- " + ingredient.toString()))));
                info.setItemIcon(Items.f_42155_);
                break;
            }
            case PRODUCE: {
                info.addTooltip((Component)Component.m_237110_((String)"custommachinery.requirements.drop.info.produce", (Object[])new Object[]{Component.m_237113_((String)(this.amount + "x ")).m_7220_((Component)Component.m_237115_((String)this.output.m_5524_())).m_130940_(ChatFormatting.GOLD)}));
                info.setItemIcon(Items.f_42162_);
            }
        }
    }

    public static enum Action {
        CHECK,
        CONSUME,
        PRODUCE;

        public static final NamedCodec<Action> CODEC;

        public static Action value(String mode) {
            return Action.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }

        static {
            CODEC = NamedCodec.enumCodec(Action.class);
        }
    }
}

