/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.api.network.DataType;
import fr.frinn.custommachinery.api.network.IData;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.network.SUpdateContainerPacket;
import fr.frinn.custommachinery.common.network.syncable.IntegerSyncable;
import fr.frinn.custommachinery.common.network.syncable.ItemStackSyncable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class SyncableContainer
extends AbstractContainerMenu {
    private final ServerPlayer player;
    private final List<ISyncable<?, ?>> stuffToSync = new ArrayList();
    private final ISyncableStuff syncableStuff;

    public SyncableContainer(@Nullable MenuType<?> type, int id, ISyncableStuff syncableStuff, Player player) {
        super(type, id);
        ServerPlayer serverPlayer;
        this.player = player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null;
        this.syncableStuff = syncableStuff;
    }

    public void init() {
        this.stuffToSync.clear();
        this.stuffToSync.add(DataType.createSyncable(ItemStack.class, () -> ((SyncableContainer)this).m_142621_(), arg_0 -> ((SyncableContainer)this).m_142503_(arg_0)));
        this.syncableStuff.getStuffToSync(this.stuffToSync::add);
    }

    public abstract boolean needFullSync();

    public void m_38946_() {
        if (this.player != null) {
            if (this.needFullSync()) {
                ArrayList toSync = new ArrayList();
                for (short id = 0; id < this.stuffToSync.size(); id = (short)(id + 1)) {
                    toSync.add((IData<?>)this.stuffToSync.get(id).getData(id));
                }
                new SUpdateContainerPacket(this.f_38840_, toSync).sendTo(this.player);
                return;
            }
            ArrayList toSync = new ArrayList();
            for (short id = 0; id < this.stuffToSync.size(); id = (short)((short)(id + 1))) {
                if (!this.stuffToSync.get(id).needSync()) continue;
                toSync.add((IData<?>)this.stuffToSync.get(id).getData(id));
            }
            if (!toSync.isEmpty()) {
                new SUpdateContainerPacket(this.f_38840_, toSync).sendTo(this.player);
            }
        }
    }

    public void handleData(IData<?> data) {
        short id = data.getID();
        ISyncable<?, ?> syncable = this.stuffToSync.get(id);
        if (syncable != null) {
            syncable.set(data.getValue());
        }
    }

    protected DataSlot m_38895_(DataSlot intReferenceHolder) {
        this.stuffToSync.add(IntegerSyncable.create(() -> ((DataSlot)intReferenceHolder).m_6501_(), arg_0 -> ((DataSlot)intReferenceHolder).m_6422_(arg_0)));
        return intReferenceHolder;
    }

    protected void m_38884_(ContainerData array) {
        int i = 0;
        while (i < array.m_6499_()) {
            int index = i++;
            this.stuffToSync.add(IntegerSyncable.create(() -> array.m_6413_(index), integer -> array.m_8050_(index, integer.intValue())));
        }
    }

    public void m_182410_(int stateId, List<ItemStack> items, ItemStack carried) {
    }

    protected Slot addSyncedSlot(Slot slot) {
        this.stuffToSync.add(ItemStackSyncable.create(() -> ((Slot)slot).m_7993_(), arg_0 -> ((Slot)slot).m_5852_(arg_0)));
        return this.m_38897_(slot);
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }
}

