/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.client.ClientPacketHandler;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.UpgradedCustomMachine;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.util.Comparators;
import io.netty.handler.codec.EncoderException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class SUpdateMachinesPacket
extends BaseS2CMessage {
    private final Map<ResourceLocation, CustomMachine> machines;

    public SUpdateMachinesPacket(Map<ResourceLocation, CustomMachine> machines) {
        this.machines = new HashMap<ResourceLocation, CustomMachine>(machines);
    }

    public MessageType getType() {
        return PacketManager.UPDATE_MACHINES;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.machines.size());
        this.machines.values().stream().sorted(Comparators.PARENT_MACHINE_FIRST).forEach(machine -> {
            try {
                MachineLocation.CODEC.toNetwork(machine.getLocation(), buf);
                if (machine instanceof UpgradedCustomMachine) {
                    UpgradedCustomMachine upgradedMachine = (UpgradedCustomMachine)machine;
                    buf.writeBoolean(true);
                    buf.m_130085_(((UpgradedCustomMachine)machine).getParentId());
                    UpgradedCustomMachine.makeCodec(this.machines.get(upgradedMachine.getParentId())).toNetwork(upgradedMachine, buf);
                } else {
                    buf.writeBoolean(false);
                    CustomMachine.CODEC.toNetwork((CustomMachine)machine, buf);
                }
            }
            catch (EncoderException e) {
                e.printStackTrace();
            }
        });
    }

    public static SUpdateMachinesPacket read(FriendlyByteBuf buf) {
        HashMap<ResourceLocation, CustomMachine> map = new HashMap<ResourceLocation, CustomMachine>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            try {
                CustomMachine machine;
                MachineLocation location = MachineLocation.CODEC.fromNetwork(buf);
                if (buf.readBoolean()) {
                    ResourceLocation parent = buf.m_130281_();
                    machine = UpgradedCustomMachine.makeCodec((CustomMachine)map.get(parent)).fromNetwork(buf);
                } else {
                    machine = CustomMachine.CODEC.fromNetwork(buf);
                }
                machine.setLocation(location);
                map.put(location.getId(), machine);
                continue;
            }
            catch (EncoderException e) {
                e.printStackTrace();
            }
        }
        return new SUpdateMachinesPacket(map);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.CLIENT) {
            context.queue(() -> ClientPacketHandler.handleUpdateMachinesPacket(this.machines));
        }
    }
}

