/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CRemoveMachinePacket
extends BaseC2SMessage {
    private final ResourceLocation id;

    public CRemoveMachinePacket(ResourceLocation id) {
        this.id = id;
    }

    public MessageType getType() {
        return PacketManager.REMOVE_MACHINE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
    }

    public static CRemoveMachinePacket read(FriendlyByteBuf buf) {
        return new CRemoveMachinePacket(buf.m_130281_());
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.SERVER) {
            ServerPlayer player;
            CustomMachine machine = CustomMachinery.MACHINES.get(this.id);
            Player player2 = context.getPlayer();
            if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).m_20194_() != null && Utils.canPlayerManageMachines((Player)player) && machine != null) {
                context.queue(() -> {
                    CustomMachinery.LOGGER.info("Player: {} removed machine: {}", (Object)player.m_5446_().getString(), (Object)this.id);
                    CustomMachinery.MACHINES.remove(this.id);
                    FileUtils.deleteMachineJson(player.m_20194_(), machine.getLocation());
                });
            }
        }
    }
}

