/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.network.PacketManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class CGuiElementClickPacket
extends BaseC2SMessage {
    private final int element;
    private final byte type;

    public CGuiElementClickPacket(int element, byte type) {
        this.element = element;
        this.type = type;
    }

    public MessageType getType() {
        return PacketManager.ELEMENT_CLICKED;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.element);
        buf.writeByte((int)this.type);
    }

    public static CGuiElementClickPacket read(FriendlyByteBuf buf) {
        return new CGuiElementClickPacket(buf.m_130242_(), buf.readByte());
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.SERVER) {
            context.queue(() -> {
                Player player = context.getPlayer();
                if (player != null && player.f_36096_ instanceof CustomMachineContainer) {
                    ((CustomMachineContainer)player.f_36096_).elementClicked(this.element, this.type);
                }
            });
        }
    }
}

