/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.network.SUpdateMachinesPacket;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.MachineList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CEditMachinePacket
extends BaseC2SMessage {
    private final CustomMachine machine;

    public CEditMachinePacket(CustomMachine machine) {
        this.machine = machine;
    }

    public MessageType getType() {
        return PacketManager.EDIT_MACHINE;
    }

    public static CEditMachinePacket read(FriendlyByteBuf buf) {
        MachineLocation location = MachineLocation.CODEC.fromNetwork(buf);
        CustomMachine machine = CustomMachine.CODEC.fromNetwork(buf);
        machine.setLocation(location);
        return new CEditMachinePacket(machine);
    }

    public void write(FriendlyByteBuf buf) {
        MachineLocation.CODEC.toNetwork(this.machine.getLocation(), buf);
        CustomMachine.CODEC.toNetwork(this.machine, buf);
    }

    public void handle(NetworkManager.PacketContext context) {
        ServerPlayer player;
        Player player2;
        if (context.getEnvironment() == Env.SERVER && (player2 = context.getPlayer()) instanceof ServerPlayer && (player = (ServerPlayer)player2).m_20310_(2)) {
            context.queue(() -> {
                FileUtils.writeMachineJson(player.f_8924_, this.machine);
                CustomMachinery.MACHINES.replace(this.machine.getId(), this.machine);
                MachineList.refreshAllMachines();
            });
            new SUpdateMachinesPacket(CustomMachinery.MACHINES).sendToAll(player.f_8924_);
        }
    }
}

