/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CAddMachinePacket
extends BaseC2SMessage {
    private final String id;
    private final Component name;
    private final boolean kubejs;

    public CAddMachinePacket(String id, Component name, boolean kubejs) {
        this.id = id;
        this.name = name;
        this.kubejs = kubejs;
    }

    public MessageType getType() {
        return PacketManager.ADD_MACHINE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.id);
        buf.m_130083_(this.name);
        buf.writeBoolean(this.kubejs);
    }

    public static CAddMachinePacket read(FriendlyByteBuf buf) {
        return new CAddMachinePacket(buf.m_130277_(), buf.m_130238_(), buf.readBoolean());
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player;
        if (context.getEnvironment() == Env.SERVER && (player = context.getPlayer()) != null && player.m_20194_() != null && Utils.canPlayerManageMachines(player)) {
            context.queue(() -> {
                CustomMachinery.LOGGER.info("Player: " + player.m_5446_().getString() + " added new Machine: " + this.id);
                CustomMachine newMachine = new CustomMachineBuilder().setLocation(MachineLocation.fromLoader(this.kubejs ? MachineLocation.Loader.KUBEJS : MachineLocation.Loader.DEFAULT, new ResourceLocation("custommachinery", this.id), "")).setName(this.name).build();
                FileUtils.writeNewMachineJson(player.m_20194_(), newMachine, this.kubejs);
            });
        }
    }
}

