/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine.builder;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.MachineModelLocation;
import fr.frinn.custommachinery.common.util.MachineShape;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class MachineAppearanceBuilder {
    @Nullable
    private final MachineStatus status;
    private final Map<MachineAppearanceProperty<?>, Object> properties;

    public MachineAppearanceBuilder(@Nullable MachineStatus status) {
        this.status = status;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MachineAppearanceProperty property : Registration.APPEARANCE_PROPERTY_REGISTRY) {
            builder.put((Object)property, property.getDefaultValue());
        }
        this.properties = builder.build();
    }

    public MachineAppearanceBuilder(MachineAppearance appearance, @Nullable MachineStatus status) {
        this.status = status;
        this.properties = Maps.newHashMap(appearance.getProperties());
    }

    public MachineAppearanceBuilder(Map<MachineAppearanceProperty<?>, Object> properties, @Nullable MachineStatus status) {
        this.status = status;
        this.properties = Maps.newHashMap(properties);
    }

    @Nullable
    public MachineStatus getStatus() {
        return this.status;
    }

    public <T> T getProperty(MachineAppearanceProperty<T> property) {
        if (!this.properties.containsKey(property)) {
            throw new IllegalStateException("Can't get Machine Appearance property for: " + property.getId() + ", this property may not be registered");
        }
        return (T)this.properties.get(property);
    }

    public <T> void setProperty(MachineAppearanceProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public MachineModelLocation getBlockModel() {
        return (MachineModelLocation)this.getProperty((MachineAppearanceProperty)Registration.BLOCK_MODEL_PROPERTY.get());
    }

    public void setBlockModel(MachineModelLocation blockModel) {
        this.setProperty((MachineAppearanceProperty)Registration.BLOCK_MODEL_PROPERTY.get(), blockModel);
    }

    public MachineModelLocation getItemModel() {
        return (MachineModelLocation)this.getProperty((MachineAppearanceProperty)Registration.ITEM_MODEL_PROPERTY.get());
    }

    public void setItemModel(MachineModelLocation itemModel) {
        this.setProperty((MachineAppearanceProperty)Registration.ITEM_MODEL_PROPERTY.get(), itemModel);
    }

    public SoundEvent getSound() {
        return (SoundEvent)this.getProperty((MachineAppearanceProperty)Registration.AMBIENT_SOUND_PROPERTY.get());
    }

    public void setSound(SoundEvent sound) {
        this.setProperty((MachineAppearanceProperty)Registration.AMBIENT_SOUND_PROPERTY.get(), sound);
    }

    public int getLightLevel() {
        return (Integer)this.getProperty((MachineAppearanceProperty)Registration.LIGHT_PROPERTY.get());
    }

    public void setLightLevel(int lightLevel) {
        this.setProperty((MachineAppearanceProperty)Registration.LIGHT_PROPERTY.get(), Mth.m_14045_((int)lightLevel, (int)0, (int)15));
    }

    public int getColor() {
        return (Integer)this.getProperty((MachineAppearanceProperty)Registration.COLOR_PROPERTY.get());
    }

    public void setColor(int color) {
        this.setProperty((MachineAppearanceProperty)Registration.COLOR_PROPERTY.get(), color);
    }

    public float getHardness() {
        return ((Float)this.getProperty((MachineAppearanceProperty)Registration.HARDNESS_PROPERTY.get())).floatValue();
    }

    public void setHardness(float hardness) {
        this.setProperty((MachineAppearanceProperty)Registration.HARDNESS_PROPERTY.get(), Float.valueOf(Mth.m_14036_((float)hardness, (float)0.0f, (float)Float.MAX_VALUE)));
    }

    public float getResistance() {
        return ((Float)this.getProperty((MachineAppearanceProperty)Registration.RESISTANCE_PROPERTY.get())).floatValue();
    }

    public void setResistance(float resistance) {
        this.setProperty((MachineAppearanceProperty)Registration.RESISTANCE_PROPERTY.get(), Float.valueOf(Mth.m_14036_((float)resistance, (float)0.0f, (float)Float.MAX_VALUE)));
    }

    public List<TagKey<Block>> getToolType() {
        return (List)this.getProperty((MachineAppearanceProperty)Registration.TOOL_TYPE_PROPERTY.get());
    }

    public void setToolType(TagKey<Block> toolType) {
        this.setProperty((MachineAppearanceProperty)Registration.TOOL_TYPE_PROPERTY.get(), Collections.singletonList(toolType));
    }

    public TagKey<Block> getMiningLevel() {
        return (TagKey)this.getProperty((MachineAppearanceProperty)Registration.MINING_LEVEL_PROPERTY.get());
    }

    public void setMiningLevel(TagKey<Block> miningLevel) {
        this.setProperty((MachineAppearanceProperty)Registration.MINING_LEVEL_PROPERTY.get(), miningLevel);
    }

    public MachineShape getShape() {
        return (MachineShape)this.getProperty((MachineAppearanceProperty)Registration.SHAPE_PROPERTY.get());
    }

    public void setShape(MachineShape shape) {
        this.setProperty((MachineAppearanceProperty)Registration.SHAPE_PROPERTY.get(), shape);
    }

    public MachineAppearance build() {
        return new MachineAppearance((Map<MachineAppearanceProperty<?>, Object>)ImmutableMap.copyOf(this.properties));
    }
}

