/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.common.requirement.StructureRequirement;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface StructureRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder destroyStructure(String[][] pattern, Map<String, String> keys) {
        return this.requireStructure(pattern, keys, StructureRequirement.Action.DESTROY);
    }

    default public RecipeJSBuilder breakStructure(String[][] pattern, Map<String, String> keys) {
        return this.requireStructure(pattern, keys, StructureRequirement.Action.BREAK);
    }

    default public RecipeJSBuilder requireStructure(String[][] pattern, Map<String, String> keys) {
        return this.requireStructure(pattern, keys, StructureRequirement.Action.CHECK);
    }

    default public RecipeJSBuilder placeStructure(String[][] pattern, Map<String, String> keys, boolean drops) {
        return this.requireStructure(pattern, keys, drops ? StructureRequirement.Action.PLACE_BREAK : StructureRequirement.Action.PLACE_DESTROY);
    }

    default public RecipeJSBuilder requireStructure(String[][] pattern, Map<String, String> keys, StructureRequirement.Action action) {
        List<List<String>> patternList = Arrays.stream(pattern).map(floors -> Arrays.stream(floors).toList()).toList();
        HashMap<Character, IIngredient<PartialBlockState>> keysMap = new HashMap<Character, IIngredient<PartialBlockState>>();
        for (Map.Entry<String, String> entry : keys.entrySet()) {
            if (entry.getKey().length() != 1) {
                return this.error("Invalid structure key: \"{}\" must be a single character which is not 'm'", entry.getKey());
            }
            char keyChar = entry.getKey().charAt(0);
            DataResult<IIngredient<PartialBlockState>> result = IIngredient.BLOCK.read(JsonOps.INSTANCE, new JsonPrimitive(entry.getValue()));
            if (result.error().isPresent() || result.result().isEmpty()) {
                return this.error("Invalid structure block: \"{}\", {}", entry.getValue(), ((DataResult.PartialResult)result.error().get()).message());
            }
            keysMap.put(Character.valueOf(keyChar), (IIngredient)result.result().get());
        }
        try {
            return this.addRequirement(new StructureRequirement(patternList, keysMap, action));
        }
        catch (IllegalStateException e) {
            return this.error("Error while creating structure requirement: {}\nPattern: {}\nKeys: {}", new Object[]{e.getMessage(), pattern, keys});
        }
    }
}

