/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.kubejs.KubeJSIntegration;
import fr.frinn.custommachinery.common.requirement.DurabilityRequirement;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemTagIngredient;
import java.util.Map;
import net.minecraft.world.item.ItemStack;

public interface DurabilityRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder damageItem(ItemStack stack, int amount) {
        return this.damageItem(stack, amount, "");
    }

    default public RecipeJSBuilder damageItem(ItemStack stack, int amount, String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, new ItemIngredient(stack.m_41720_()), amount, KubeJSIntegration.nbtFromStack(stack), true, slot));
    }

    default public RecipeJSBuilder damageItemNoBreak(ItemStack stack, int amount) {
        return this.damageItem(stack, amount, "");
    }

    default public RecipeJSBuilder damageItemNoBreak(ItemStack stack, int amount, String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, new ItemIngredient(stack.m_41720_()), amount, KubeJSIntegration.nbtFromStack(stack), false, slot));
    }

    default public RecipeJSBuilder damageItemTag(String tag, int amount) {
        return this.damageItemTag(tag, amount, null, "");
    }

    default public RecipeJSBuilder damageItemTag(String tag, int amount, Object thing) {
        if (thing instanceof String) {
            return this.damageItemTag(tag, amount, null, (String)thing);
        }
        return this.damageItemTag(tag, amount, MapJS.of((Object)thing), "");
    }

    default public RecipeJSBuilder damageItemTag(String tag, int amount, Map<?, ?> nbt, String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, ItemTagIngredient.create(tag), amount, nbt == null ? null : NBTUtils.toTagCompound(nbt), true, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    default public RecipeJSBuilder damageItemTagNoBreak(String tag, int amount) {
        return this.damageItemTagNoBreak(tag, amount, null, "");
    }

    default public RecipeJSBuilder damageItemTagNoBreak(String tag, int amount, Object thing) {
        if (thing instanceof String) {
            return this.damageItemTagNoBreak(tag, amount, null, (String)thing);
        }
        return this.damageItemTagNoBreak(tag, amount, MapJS.of((Object)thing), "");
    }

    default public RecipeJSBuilder damageItemTagNoBreak(String tag, int amount, Map<?, ?> nbt, String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, ItemTagIngredient.create(tag), amount, nbt == null ? null : NBTUtils.toTagCompound(nbt), false, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    default public RecipeJSBuilder repairItem(ItemStack stack, int amount) {
        return this.repairItem(stack, amount, "");
    }

    default public RecipeJSBuilder repairItem(ItemStack stack, int amount, String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.OUTPUT, new ItemIngredient(stack.m_41720_()), amount, KubeJSIntegration.nbtFromStack(stack), false, slot));
    }

    default public RecipeJSBuilder repairItemTag(String tag, int amount) {
        return this.repairItemTag(tag, amount, null, "");
    }

    default public RecipeJSBuilder repairItemTag(String tag, int amount, Object thing) {
        if (thing instanceof String) {
            return this.repairItemTag(tag, amount, null, (String)thing);
        }
        return this.repairItemTag(tag, amount, MapJS.of((Object)thing), "");
    }

    default public RecipeJSBuilder repairItemTag(String tag, int amount, Map<?, ?> nbt, String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.OUTPUT, ItemTagIngredient.create(tag), amount, nbt == null ? null : NBTUtils.toTagCompound(nbt), false, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }
}

