/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.ArrayRecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.integration.kubejs.CustomCraftRecipeJSBuilder;
import fr.frinn.custommachinery.common.integration.kubejs.CustomMachineRecipeBuilderJS;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import net.minecraft.resources.ResourceLocation;

public interface CustomMachineryRecipeSchemas {
    public static final RecipeComponent<ResourceLocation> RESOURCE_LOCATION = new RecipeComponent<ResourceLocation>(){

        public Class<ResourceLocation> componentClass() {
            return ResourceLocation.class;
        }

        public JsonElement write(RecipeJS recipe, ResourceLocation value) {
            return new JsonPrimitive(value.toString());
        }

        public ResourceLocation read(RecipeJS recipe, Object from) {
            String string;
            if (from instanceof JsonPrimitive) {
                JsonPrimitive json = (JsonPrimitive)from;
                string = json.getAsString();
            } else {
                string = String.valueOf(from);
            }
            return new ResourceLocation(string);
        }
    };
    public static final RecipeComponent<IRequirement<?>> REQUIREMENT_COMPONENT = new RecipeComponent<IRequirement<?>>(){

        public Class<?> componentClass() {
            return IRequirement.class;
        }

        public JsonElement write(RecipeJS recipe, IRequirement<?> value) {
            return (JsonElement)IRequirement.CODEC.encodeStart(JsonOps.INSTANCE, value).result().orElseThrow(() -> new RecipeExceptionJS("Can't write requirement: " + value));
        }

        public IRequirement<?> read(RecipeJS recipe, Object from) {
            if (from instanceof JsonElement) {
                JsonElement json = (JsonElement)from;
                return (IRequirement)IRequirement.CODEC.read(JsonOps.INSTANCE, json).result().orElseThrow(() -> new RecipeExceptionJS("Can't parse requirement: " + from));
            }
            throw new RecipeExceptionJS("Can't parse requirement: " + from);
        }
    };
    public static final ArrayRecipeComponent<IRequirement<?>> REQUIREMENT_LIST = REQUIREMENT_COMPONENT.asArray();
    public static final RecipeComponent<MachineAppearance> CUSTOM_APPEARANCE = new RecipeComponent<MachineAppearance>(){

        public Class<MachineAppearance> componentClass() {
            return MachineAppearance.class;
        }

        public JsonElement write(RecipeJS recipe, MachineAppearance value) {
            return MachineAppearance.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, value.getProperties()).result().orElse(null);
        }

        public MachineAppearance read(RecipeJS recipe, Object from) {
            if (from instanceof MachineAppearance) {
                MachineAppearance appearance = (MachineAppearance)from;
                return appearance;
            }
            if (from instanceof JsonObject) {
                JsonObject json = (JsonObject)from;
                return MachineAppearance.CODEC.read((DynamicOps)JsonOps.INSTANCE, json).result().map(MachineAppearance::new).orElse(null);
            }
            return null;
        }
    };
    public static final RecipeComponent<IGuiElement> CUSTOM_GUI_ELEMENTS = new RecipeComponent<IGuiElement>(){

        public Class<IGuiElement> componentClass() {
            return IGuiElement.class;
        }

        public JsonElement write(RecipeJS recipe, IGuiElement value) {
            return IGuiElement.CODEC.encodeStart(JsonOps.INSTANCE, value).result().orElse(null);
        }

        public IGuiElement read(RecipeJS recipe, Object from) {
            if (from instanceof IGuiElement) {
                IGuiElement element = (IGuiElement)from;
                return element;
            }
            if (from instanceof JsonObject) {
                JsonObject json = (JsonObject)from;
                return IGuiElement.CODEC.read(JsonOps.INSTANCE, json).result().orElse(null);
            }
            return null;
        }
    };
    public static final RecipeKey<ResourceLocation> MACHINE_ID = RESOURCE_LOCATION.key("machine");
    public static final RecipeKey<Long> TIME = TimeComponent.TICKS.key("time");
    public static final RecipeKey<OutputItem> OUTPUT = ItemComponents.OUTPUT.key("output");
    public static final RecipeKey<IRequirement<?>[]> REQUIREMENTS = REQUIREMENT_LIST.key("requirements").optional((Object)new IRequirement[0]).alwaysWrite().exclude();
    public static final RecipeKey<IRequirement<?>[]> JEI_REQUIREMENTS = REQUIREMENT_LIST.key("jei").optional((Object)new IRequirement[0]).alwaysWrite().exclude();
    public static final RecipeKey<Integer> PRIORITY = NumberComponent.INT.key("priority").optional((Object)0).alwaysWrite().exclude();
    public static final RecipeKey<Integer> JEI_PRIORITY = NumberComponent.INT.key("jeiPriority").optional((Object)0).alwaysWrite().exclude();
    public static final RecipeKey<Boolean> ERROR = BooleanComponent.BOOLEAN.key("error").optional((Object)false).alwaysWrite().exclude();
    public static final RecipeKey<Boolean> HIDDEN = BooleanComponent.BOOLEAN.key("hidden").optional((Object)false).alwaysWrite().exclude();
    public static final RecipeKey<MachineAppearance> APPEARANCE = CUSTOM_APPEARANCE.key("appearance").optional((Object)null).alwaysWrite().exclude();
    public static final RecipeKey<IGuiElement[]> GUI = CUSTOM_GUI_ELEMENTS.asArray().key("gui").optional((Object)new IGuiElement[0]).alwaysWrite().exclude();
    public static final RecipeSchema CUSTOM_MACHINE = new RecipeSchema(CustomMachineRecipeBuilderJS.class, CustomMachineRecipeBuilderJS::new, new RecipeKey[]{MACHINE_ID, TIME, REQUIREMENTS, JEI_REQUIREMENTS, PRIORITY, JEI_PRIORITY, ERROR, HIDDEN, APPEARANCE, GUI});
    public static final RecipeSchema CUSTOM_CRAFT = new RecipeSchema(CustomCraftRecipeJSBuilder.class, CustomCraftRecipeJSBuilder::new, new RecipeKey[]{MACHINE_ID, OUTPUT, REQUIREMENTS, JEI_REQUIREMENTS, PRIORITY, JEI_PRIORITY, HIDDEN});
}

