/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CustomMachineBlockBuilderJS
extends BuilderBase<Block> {
    public static final List<String> VALID_RENDER_TYPES = List.of("solid", "cutout", "translucent");
    private ResourceLocation machineID;
    private String renderType;
    private boolean occlusion;

    public CustomMachineBlockBuilderJS(ResourceLocation i) {
        super(i);
        this.machineID = this.id;
        this.renderType = "translucent";
        this.occlusion = false;
    }

    public CustomMachineBlockBuilderJS machine(ResourceLocation machineID) {
        this.machineID = machineID;
        return this;
    }

    public CustomMachineBlockBuilderJS renderType(String renderType) {
        if (!VALID_RENDER_TYPES.contains(renderType)) {
            throw new IllegalArgumentException("Render type: '" + renderType + "' is not supported, must be one of " + VALID_RENDER_TYPES);
        }
        this.renderType = renderType;
        return this;
    }

    public CustomMachineBlockBuilderJS occlude() {
        this.occlusion = true;
        return this;
    }

    public RegistryInfo getRegistryType() {
        return RegistryInfo.BLOCK;
    }

    public Block createObject() {
        CustomMachineBlock block = new CustomMachineBlock(this.renderType, this.occlusion);
        CustomMachinery.CUSTOM_BLOCK_MACHINES.put((Object)this.machineID, (Object)block);
        if (Platform.isFabric()) {
            ((BlockEntityType)Registration.CUSTOM_MACHINE_TILE.get()).f_58915_.add(block);
        }
        return block;
    }

    public void createAdditionalObjects() {
        RegistryInfo.ITEM.addBuilder((BuilderBase)new ItemBuilder(this.id){

            public Item createObject() {
                return new CustomMachineItem((Block)CustomMachineBlockBuilderJS.this.get(), new Item.Properties(), CustomMachineBlockBuilderJS.this.machineID);
            }

            public void generateAssetJsons(AssetJsonGenerator generator) {
                JsonObject json = new JsonObject();
                json.add("parent", (JsonElement)new JsonPrimitive("custommachinery:block/custom_machine_block"));
                JsonObject defaultJson = new JsonObject();
                defaultJson.add("", (JsonElement)new JsonPrimitive("custommachinery:default/custom_machine_default"));
                json.add("defaults", (JsonElement)defaultJson);
                generator.json(AssetJsonGenerator.asItemModelLocation((ResourceLocation)this.id), (JsonElement)json);
            }
        });
    }

    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.blockState(this.id, stateGenerator -> stateGenerator.variant("", "custommachinery:block/custom_machine_block"));
    }
}

