/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.MCTag;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.common.integration.crafttweaker.CTUtils;
import fr.frinn.custommachinery.common.requirement.ItemTransformRequirement;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemTagIngredient;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.ItemTransform")
public interface ItemTransformRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T transformItem(IItemStack stack, @ZenCodeType.Optional IItemStack output, @ZenCodeType.OptionalString String inputSlot, @ZenCodeType.OptionalString String outputSlot, @ZenCodeType.Optional Function<MapData, MapData> nbt) {
        Item outputItem = output == null ? Items.f_41852_ : output.getDefinition();
        int outputAmount = output == null ? 1 : output.getAmount();
        return this.addRequirement(new ItemTransformRequirement(new ItemIngredient(stack.getDefinition()), stack.getAmount(), inputSlot, CTUtils.nbtFromStack(stack), outputItem, outputAmount, outputSlot, true, new NbtTransformer(nbt)));
    }

    @ZenCodeType.Method
    default public T transformItemTag(MCTag tag, @ZenCodeType.OptionalInt(value=1) int inputAmount, @ZenCodeType.Optional IData data, @ZenCodeType.Optional IItemStack output, @ZenCodeType.OptionalString String inputSlot, @ZenCodeType.OptionalString String outputSlot, @ZenCodeType.Optional Function<MapData, MapData> nbt) {
        Item outputItem = output == null ? Items.f_41852_ : output.getDefinition();
        int outputAmount = output == null ? 1 : output.getAmount();
        return this.addRequirement(new ItemTransformRequirement(ItemTagIngredient.create((TagKey<Item>)tag.getTagKey()), inputAmount, inputSlot, CTUtils.getNBT(data), outputItem, outputAmount, outputSlot, true, new NbtTransformer(nbt)));
    }

    public static class NbtTransformer
    implements Function<CompoundTag, CompoundTag> {
        private final Function<MapData, MapData> function;

        public NbtTransformer(Function<MapData, MapData> function) {
            this.function = function;
        }

        @Override
        public CompoundTag apply(@Nullable CompoundTag compoundTag) {
            return this.function.apply(new MapData(compoundTag)).getInternal();
        }
    }
}

