/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.MCTag;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.crafttweaker.CTUtils;
import fr.frinn.custommachinery.common.requirement.ItemRequirement;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemTagIngredient;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Item")
public interface ItemRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T requireItem(IItemStack stack, @ZenCodeType.OptionalString String slot) {
        return this.addRequirement(new ItemRequirement(RequirementIOMode.INPUT, new ItemIngredient(stack.getDefinition()), stack.getAmount(), CTUtils.nbtFromStack(stack), slot));
    }

    @ZenCodeType.Method
    default public T requireItemTag(MCTag tag, @ZenCodeType.OptionalInt(value=1) int amount, @ZenCodeType.Optional IData data, @ZenCodeType.OptionalString String slot) {
        try {
            return this.addRequirement(new ItemRequirement(RequirementIOMode.INPUT, ItemTagIngredient.create((TagKey<Item>)tag.getTagKey()), amount, CTUtils.getNBT(data), slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    @ZenCodeType.Method
    default public T produceItem(IItemStack stack, @ZenCodeType.OptionalString String slot) {
        return this.addRequirement(new ItemRequirement(RequirementIOMode.OUTPUT, new ItemIngredient(stack.getDefinition()), stack.getAmount(), CTUtils.nbtFromStack(stack), slot));
    }
}

