/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.util.CMSoundType;
import fr.frinn.custommachinery.common.util.MachineModelLocation;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.AppearanceBuilder")
public class MachineAppearanceBuilderCT {
    private final Map<MachineAppearanceProperty<?>, Object> properties = MachineAppearance.defaultProperties();

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="block")
    public MachineAppearanceBuilderCT block(String block) {
        this.put((MachineAppearanceProperty)Registration.BLOCK_MODEL_PROPERTY.get(), MachineModelLocation.of(block));
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="item")
    public MachineAppearanceBuilderCT item(String item) {
        this.put((MachineAppearanceProperty)Registration.ITEM_MODEL_PROPERTY.get(), MachineModelLocation.of(item));
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="ambient_sound")
    public MachineAppearanceBuilderCT ambientSound(SoundEvent sound) {
        this.put((MachineAppearanceProperty)Registration.AMBIENT_SOUND_PROPERTY.get(), sound);
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="interaction_sound")
    public MachineAppearanceBuilderCT interactionSound(Block sound) {
        this.put((MachineAppearanceProperty)Registration.INTERACTION_SOUND_PROPERTY.get(), new CMSoundType(new PartialBlockState(sound)));
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="light")
    public MachineAppearanceBuilderCT light(int light) {
        this.put((MachineAppearanceProperty)Registration.LIGHT_PROPERTY.get(), Mth.m_14045_((int)light, (int)0, (int)15));
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="color")
    public MachineAppearanceBuilderCT color(int color) {
        this.put((MachineAppearanceProperty)Registration.COLOR_PROPERTY.get(), color);
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="hardness")
    public MachineAppearanceBuilderCT hardness(float hardness) {
        this.put((MachineAppearanceProperty)Registration.HARDNESS_PROPERTY.get(), Float.valueOf(hardness));
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="resistance")
    public MachineAppearanceBuilderCT resistance(float resistance) {
        this.put((MachineAppearanceProperty)Registration.RESISTANCE_PROPERTY.get(), Float.valueOf(resistance));
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="tool_type")
    public MachineAppearanceBuilderCT toolType(String[] tools) {
        List<TagKey> list = Arrays.stream(tools).map(key -> TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(key))).toList();
        this.put((MachineAppearanceProperty)Registration.TOOL_TYPE_PROPERTY.get(), list);
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="mining_level")
    public MachineAppearanceBuilderCT miningLevel(String key) {
        TagKey level = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(key));
        this.put((MachineAppearanceProperty)Registration.MINING_LEVEL_PROPERTY.get(), level);
        return this;
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="requires_tool")
    public MachineAppearanceBuilderCT requiresTool(boolean requires) {
        this.put((MachineAppearanceProperty)Registration.REQUIRES_TOOL.get(), requires);
        return this;
    }

    private <T> void put(MachineAppearanceProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public MachineAppearance build() {
        return new MachineAppearance(this.properties);
    }
}

