/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.config;

import com.google.common.collect.Lists;
import fr.frinn.custommachinery.common.util.LoggingLevel;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="custommachinery")
public class CMConfig
implements ConfigData {
    @ConfigEntry.Category(value="Logs")
    @Comment(value="If true, all missing optional properties\nand their default values will be logged\nwhen parsing custom machines jsons.")
    public boolean logMissingOptional = false;
    @ConfigEntry.Category(value="Logs")
    @Comment(value="When parsing custom machines json files,\nsome properties can be read with 2 serializers.\nSet this to true to log when the first serializer throw an error,\neven if the second succeed.")
    public boolean logFirstEitherError = false;
    @ConfigEntry.Category(value="Logs")
    @Comment(value="Configure what logs will be printed in the custommachinery.log file.\nOnly logs with level higher or equal than selected will be printed.\nFATAL > ERROR > WARN > INFO > DEBUG > ALL")
    public LoggingLevel debugLevel = LoggingLevel.INFO;
    @ConfigEntry.Category(value="Rendering")
    @Comment(value="The time in milliseconds the block requirement\nworking box will be rendered around the machines\nwhen clicking on the icon in the jei recipe.")
    public int boxRenderTime = 10000;
    @ConfigEntry.Category(value="Rendering")
    @Comment(value="The time in milliseconds the structure requirement\nstructure will render in world when clicking\non the icon in the jei recipe.")
    public int structureRenderTime = 10000;
    @ConfigEntry.Category(value="Rendering")
    @Comment(value="The time in milliseconds each blocks will be shown\nwhen using a block tag in a structure.")
    public int blockTagCycleTime = 1000;
    @ConfigEntry.Category(value="Rendering")
    @Comment(value="The time in milliseconds the ghost item will be shown\nin a slot when a tag or more than 1 item is specified.")
    public int itemSlotCycleTime = 1000;
    @ConfigEntry.Category(value="Rendering")
    @Comment(value="If true the player will need to enable advanced item tooltips (F3 + H)\nto see the recipe name when hovering the progress arrow on a recipe in jei")
    public boolean needAdvancedInfoForRecipeID = true;
    @ConfigEntry.Category(value="Misc")
    @Comment(value="A list of folder names where CM will load models json.\nThese folders must be under the \"assets/namespace/models\" folder.")
    public List<String> modelFolders = Lists.newArrayList((Object[])new String[]{"machine", "machines"});
    @ConfigEntry.Category(value="Misc")
    @Comment(value="The default directory for new machine json files.\nThe default is the root of the modpack folder.\nSpecify as a relative path (\"saves/my-world/datapacks/My Pack/data/custommachinery/machines\")")
    public String defaultNewMachinePath = "";

    public static CMConfig get() {
        return (CMConfig)AutoConfig.getConfigHolder(CMConfig.class).getConfig();
    }
}

