/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class StructureCreatorItem
extends Item {
    private static final NamedCodec<List<List<String>>> PATTERN_CODEC = NamedCodec.STRING.listOf().listOf();
    private static final NamedCodec<Map<Character, PartialBlockState>> KEYS_CODEC = NamedCodec.unboundedMap(DefaultCodecs.CHARACTER, PartialBlockState.CODEC, "Map<Character, Block>");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public StructureCreatorItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_() == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        ItemStack stack = context.m_43722_();
        if (state.m_60734_() instanceof CustomMachineBlock) {
            if (!context.m_43725_().m_5776_()) {
                this.finishStructure(stack, pos, (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_), (ServerPlayer)context.m_43723_());
            }
            return InteractionResult.SUCCESS;
        }
        if (!StructureCreatorItem.getSelectedBlocks(stack).contains(pos)) {
            StructureCreatorItem.addSelectedBlock(stack, pos);
            return InteractionResult.SUCCESS;
        }
        if (StructureCreatorItem.getSelectedBlocks(stack).contains(pos)) {
            StructureCreatorItem.removeSelectedBlock(stack, pos);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int amount = StructureCreatorItem.getSelectedBlocks(stack).size();
        if (amount <= 0) {
            tooltip.add((Component)Component.m_237115_((String)"custommachinery.structure_creator.no_blocks").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"custommachinery.structure_creator.amount", (Object[])new Object[]{StructureCreatorItem.getSelectedBlocks(stack).size()}).m_130940_(ChatFormatting.BLUE));
        }
        tooltip.add((Component)Component.m_237115_((String)"custommachinery.structure_creator.select").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"custommachinery.structure_creator.reset").m_130940_(ChatFormatting.GOLD));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6047_() && player.m_21120_(hand).m_41720_() == this) {
            ItemStack stack = player.m_21120_(hand);
            stack.m_41749_("custommachinery");
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public static List<BlockPos> getSelectedBlocks(ItemStack stack) {
        return Arrays.stream(stack.m_41698_("custommachinery").m_128467_("blocks")).mapToObj(BlockPos::m_122022_).collect(Collectors.toList());
    }

    public static void addSelectedBlock(ItemStack stack, BlockPos pos) {
        long packed = pos.m_121878_();
        long[] posList = stack.m_41698_("custommachinery").m_128467_("blocks");
        long[] newList = new long[posList.length + 1];
        System.arraycopy(posList, 0, newList, 0, posList.length);
        newList[posList.length] = packed;
        stack.m_41698_("custommachinery").m_128388_("blocks", newList);
    }

    public static void removeSelectedBlock(ItemStack stack, BlockPos pos) {
        long packed = pos.m_121878_();
        long[] posList = stack.m_41698_("custommachinery").m_128467_("blocks");
        long[] newList = Arrays.stream(posList).filter(l -> l != packed).toArray();
        stack.m_41698_("custommachinery").m_128388_("blocks", newList);
    }

    private void finishStructure(ItemStack stack, BlockPos machinePos, Direction machineFacing, ServerPlayer player) {
        List<BlockPos> blocks = StructureCreatorItem.getSelectedBlocks(stack);
        blocks.add(machinePos);
        if (blocks.size() <= 1) {
            player.m_213846_((Component)Component.m_237115_((String)"custommachinery.structure_creator.no_blocks"));
            return;
        }
        Level world = player.m_9236_();
        PartialBlockState[][][] states = this.getStructureArray(blocks, machineFacing, world);
        HashBiMap keys = HashBiMap.create();
        AtomicInteger charIndex = new AtomicInteger(97);
        Arrays.stream(states).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(state -> !(state.getBlockState().m_60734_() instanceof CustomMachineBlock) && state != PartialBlockState.ANY).distinct().forEach(state -> {
            if (charIndex.get() == 109) {
                charIndex.incrementAndGet();
            }
            keys.put((Object)Character.valueOf((char)charIndex.getAndIncrement()), state);
            if (charIndex.get() == 122) {
                charIndex.set(65);
            }
        });
        ArrayList pattern = new ArrayList();
        for (int i = 0; i < states.length; ++i) {
            ArrayList<String> floor = new ArrayList<String>();
            for (int j = 0; j < states[i].length; ++j) {
                StringBuilder row = new StringBuilder();
                for (int k = 0; k < states[i][j].length; ++k) {
                    PartialBlockState partial = states[i][j][k];
                    int key = partial.getBlockState().m_60734_() instanceof CustomMachineBlock ? 109 : (partial == PartialBlockState.ANY ? 32 : (keys.containsValue((Object)partial) ? (int)((Character)keys.inverse().get((Object)partial)).charValue() : 63));
                    row.append((char)key);
                }
                floor.add(row.toString());
            }
            pattern.add(floor);
        }
        JsonElement keysJson = (JsonElement)KEYS_CODEC.encodeStart(JsonOps.INSTANCE, (Map<Character, PartialBlockState>)keys).result().orElseThrow(IllegalStateException::new);
        JsonElement patternJson = (JsonElement)PATTERN_CODEC.encodeStart(JsonOps.INSTANCE, pattern).result().orElseThrow(IllegalStateException::new);
        JsonObject both = new JsonObject();
        both.add("keys", keysJson);
        both.add("pattern", patternJson);
        String ctKubeString = ".requireStructure(" + patternJson.toString() + ", " + keysJson.toString() + ")";
        MutableComponent jsonText = Component.m_237113_((String)"[JSON]").m_130938_(style -> style.m_131152_(new ChatFormatting[]{ChatFormatting.YELLOW}).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)both.toString()))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, both.toString())));
        MutableComponent prettyJsonText = Component.m_237113_((String)"[PRETTY JSON]").m_130938_(style -> style.m_131152_(new ChatFormatting[]{ChatFormatting.GOLD}).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)GSON.toJson((JsonElement)both)))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, GSON.toJson((JsonElement)both))));
        MutableComponent crafttweakerText = Component.m_237113_((String)"[CRAFTTWEAKER]").m_130938_(style -> style.m_131152_(new ChatFormatting[]{ChatFormatting.AQUA}).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)ctKubeString))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ctKubeString)));
        MutableComponent kubeJSText = Component.m_237113_((String)"[KUBEJS]").m_130938_(style -> style.m_131152_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE}).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)ctKubeString))).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ctKubeString)));
        MutableComponent message = Component.m_237110_((String)"custommachinery.structure_creator.message", (Object[])new Object[]{jsonText, prettyJsonText, crafttweakerText, kubeJSText});
        player.m_213846_((Component)message);
    }

    private PartialBlockState[][][] getStructureArray(List<BlockPos> blocks, Direction machineFacing, Level world) {
        int minX = blocks.stream().mapToInt(Vec3i::m_123341_).min().orElseThrow(IllegalStateException::new);
        int maxX = blocks.stream().mapToInt(Vec3i::m_123341_).max().orElseThrow(IllegalStateException::new);
        int minY = blocks.stream().mapToInt(Vec3i::m_123342_).min().orElseThrow(IllegalStateException::new);
        int maxY = blocks.stream().mapToInt(Vec3i::m_123342_).max().orElseThrow(IllegalStateException::new);
        int minZ = blocks.stream().mapToInt(Vec3i::m_123343_).min().orElseThrow(IllegalStateException::new);
        int maxZ = blocks.stream().mapToInt(Vec3i::m_123343_).max().orElseThrow(IllegalStateException::new);
        PartialBlockState[][][] states = machineFacing.m_122434_() == Direction.Axis.X ? new PartialBlockState[maxY - minY + 1][maxX - minX + 1][maxZ - minZ + 1] : new PartialBlockState[maxY - minY + 1][maxZ - minZ + 1][maxX - minX + 1];
        AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        HashMap cache = new HashMap();
        BlockPos.m_121921_((AABB)box).forEach(p -> {
            PartialBlockState partial;
            BlockState state = world.m_8055_(p);
            if (!blocks.contains(p)) {
                partial = PartialBlockState.ANY;
            } else if (cache.containsKey(state)) {
                partial = (PartialBlockState)cache.get(state);
            } else {
                partial = new PartialBlockState(state, Lists.newArrayList((Iterable)state.m_61147_()), Optional.ofNullable(world.m_7702_(p)).map(BlockEntity::m_187480_).orElse(null));
                cache.put(state, partial);
            }
            switch (machineFacing) {
                case EAST: {
                    states[p.m_123342_() - minY][p.m_123341_() - minX][maxZ - p.m_123343_()] = partial;
                    break;
                }
                case WEST: {
                    states[p.m_123342_() - minY][maxX - p.m_123341_()][p.m_123343_() - minZ] = partial;
                    break;
                }
                case SOUTH: {
                    states[p.m_123342_() - minY][p.m_123343_() - minZ][p.m_123341_() - minX] = partial;
                    break;
                }
                case NORTH: {
                    states[p.m_123342_() - minY][maxZ - p.m_123343_()][maxX - p.m_123341_()] = partial;
                }
            }
        });
        return states;
    }
}

