/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import dev.architectury.registry.fuel.FuelRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.variant.item.DefaultItemComponentVariant;
import fr.frinn.custommachinery.common.component.variant.item.FilterItemComponentVariant;
import fr.frinn.custommachinery.common.component.variant.item.FuelItemComponentVariant;
import fr.frinn.custommachinery.common.component.variant.item.ResultItemComponentVariant;
import fr.frinn.custommachinery.common.component.variant.item.UpgradeItemComponentVariant;
import fr.frinn.custommachinery.common.crafting.craft.CraftProcessor;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.SyncableContainer;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.slot.FilterSlotItemComponent;
import fr.frinn.custommachinery.common.util.slot.ResultSlotItemComponent;
import fr.frinn.custommachinery.common.util.slot.SlotItemComponent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class CustomMachineContainer
extends SyncableContainer {
    private final Inventory playerInv;
    private final CustomMachineTile tile;
    private int firstComponentSlotIndex = 0;
    private boolean hasPlayerInventory = false;
    private final List<SlotItemComponent> inputSlotComponents = new ArrayList<SlotItemComponent>();

    public static void open(ServerPlayer player, final MachineTile machine) {
        MenuRegistry.openExtendedMenu((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return machine.getMachine().getName();
            }

            public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
                return new CustomMachineContainer(id, inv, (CustomMachineTile)machine);
            }
        }, buf -> buf.m_130064_(machine.m_58899_()));
    }

    public CustomMachineContainer(int id, Inventory playerInv, CustomMachineTile tile) {
        super((MenuType)Registration.CUSTOM_MACHINE_CONTAINER.get(), id, tile, playerInv.f_35978_);
        this.playerInv = playerInv;
        this.tile = tile;
        this.init();
        tile.startInteracting(this.getPlayer());
    }

    public CustomMachineContainer(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, ClientHandler.getClientSideCustomMachineTile(extraData.m_130135_()));
    }

    @Override
    public void init() {
        super.init();
        this.f_38839_.clear();
        this.inputSlotComponents.clear();
        AtomicInteger slotIndex = new AtomicInteger(0);
        this.tile.getGuiElements().stream().filter(element -> element.getType() == Registration.PLAYER_INVENTORY_GUI_ELEMENT.get()).findFirst().ifPresent(element -> {
            this.hasPlayerInventory = true;
            int x = element.getX() + 1;
            int y = element.getY() + 1;
            for (int k = 0; k < 9; ++k) {
                this.addSyncedSlot(new Slot((Container)this.playerInv, slotIndex.getAndIncrement(), x + k * 18, y + 58));
            }
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.addSyncedSlot(new Slot((Container)this.playerInv, slotIndex.getAndIncrement(), x + j * 18, y + i * 18));
                }
            }
        });
        this.firstComponentSlotIndex = slotIndex.get() + 1;
        this.tile.getGuiElements().stream().filter(element -> element.getType() == Registration.SLOT_GUI_ELEMENT.get()).map(element -> (SlotGuiElement)element).forEach(element -> this.tile.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(itemHandler -> itemHandler.getComponentForID(element.getComponentId())).ifPresent(component -> {
            int x = element.getX();
            int y = element.getY();
            int width = element.getWidth();
            int height = element.getHeight();
            int slotX = x + (width - 16) / 2;
            int slotY = y + (height - 16) / 2;
            SlotItemComponent slotComponent = component.getVariant() == ResultItemComponentVariant.INSTANCE ? new ResultSlotItemComponent((ItemMachineComponent)component, slotIndex.getAndIncrement(), slotX, slotY) : (component.getVariant() == FilterItemComponentVariant.INSTANCE ? new FilterSlotItemComponent((ItemMachineComponent)component, slotIndex.getAndIncrement(), slotX, slotY) : new SlotItemComponent((ItemMachineComponent)component, slotIndex.getAndIncrement(), slotX, slotY));
            this.m_38897_(slotComponent);
            if (component.getVariant() != DefaultItemComponentVariant.INSTANCE || component.getMode().isInput()) {
                this.inputSlotComponents.add(slotComponent);
            }
        }));
    }

    public CustomMachineTile getTile() {
        return this.tile;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        SlotItemComponent slot;
        Object object;
        if (slotId >= 0 && slotId < this.f_38839_.size() && (object = this.f_38839_.get(slotId)) instanceof SlotItemComponent && !(slot = (SlotItemComponent)((Object)object)).m_7993_().m_41619_()) {
            this.tile.getComponentManager().getComponent((MachineComponentType)Registration.EXPERIENCE_MACHINE_COMPONENT.get()).ifPresent(component -> {
                if (component.canRetrieveFromSlots()) {
                    if (component.slotsFromCanRetrieve().isEmpty()) {
                        player.m_6756_(Utils.toInt(component.getXp()));
                        component.extractXp(component.getXp(), false);
                    } else {
                        component.slotsFromCanRetrieve().forEach(id -> {
                            if (id.equals(slot.getComponent().getId())) {
                                player.m_6756_(Utils.toInt(component.getXp()));
                                component.extractXp(component.getXp(), false);
                            }
                        });
                    }
                }
            });
        }
        this.tile.m_6596_();
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack m_7648_(Player player, int index) {
        if (!this.hasPlayerInventory) {
            return ItemStack.f_41583_;
        }
        Slot clickedSlot = (Slot)this.f_38839_.get(index);
        if (clickedSlot.m_7993_().m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (clickedSlot.f_40218_ == this.playerInv) {
            ItemStack stack = clickedSlot.m_7993_().m_41777_();
            List<SlotItemComponent> components = !CustomMachinery.UPGRADES.getUpgradesForItemAndMachine(stack.m_41720_(), this.tile.getId()).isEmpty() ? this.inputSlotComponents.stream().sorted(Comparator.comparingInt(slot -> slot.getComponent().getVariant() == UpgradeItemComponentVariant.INSTANCE ? -1 : 1)).toList() : (FuelRegistry.get((ItemStack)stack) > 0 ? this.inputSlotComponents.stream().sorted(Comparator.comparingInt(slot -> slot.getComponent().getVariant() == FuelItemComponentVariant.INSTANCE ? -1 : 1)).toList() : this.inputSlotComponents);
            for (SlotItemComponent slotComponent2 : components) {
                if (slotComponent2.getComponent().isLocked()) continue;
                int maxInput = slotComponent2.getComponent().insert(stack.m_41720_(), stack.m_41613_(), stack.m_41783_(), true, true);
                if (maxInput > 0) {
                    int toInsert = Math.min(maxInput, stack.m_41613_());
                    slotComponent2.getComponent().insert(stack.m_41720_(), toInsert, stack.m_41783_(), false, true);
                    stack.m_41774_(toInsert);
                }
                if (!stack.m_41619_()) continue;
                break;
            }
            if (stack.m_41619_()) {
                clickedSlot.m_6201_(clickedSlot.m_7993_().m_41613_());
            } else {
                clickedSlot.m_6201_(clickedSlot.m_7993_().m_41613_() - stack.m_41613_());
            }
        } else {
            ItemStack removed;
            SlotItemComponent slotComponent;
            if (!(clickedSlot instanceof SlotItemComponent) || (slotComponent = (SlotItemComponent)clickedSlot).getComponent().isLocked()) {
                return ItemStack.f_41583_;
            }
            if (slotComponent instanceof ResultSlotItemComponent) {
                ResultSlotItemComponent resultSlot = (ResultSlotItemComponent)slotComponent;
                IProcessor slotComponent2 = this.tile.getProcessor();
                if (slotComponent2 instanceof CraftProcessor) {
                    CraftProcessor processor = (CraftProcessor)slotComponent2;
                    ItemStack removed2 = slotComponent.m_7993_().m_41777_();
                    if (!this.playerInv.m_36054_(removed2)) {
                        return ItemStack.f_41583_;
                    }
                    slotComponent.m_6654_();
                    int crafted = 0;
                    while (processor.bulkCraft()) {
                        removed2 = slotComponent.m_7993_().m_41777_();
                        if (!this.playerInv.m_36054_(removed2)) {
                            return ItemStack.f_41583_;
                        }
                        slotComponent.m_6654_();
                        if (crafted++ != 64 || !player.m_150110_().f_35937_) continue;
                        return ItemStack.f_41583_;
                    }
                    return ItemStack.f_41583_;
                }
            }
            if (!this.m_38903_(removed = slotComponent.m_7993_(), 0, this.firstComponentSlotIndex - 1, false)) {
                return ItemStack.f_41583_;
            }
            slotComponent.m_6654_();
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_9236_().m_8055_(this.tile.m_58899_()) == this.tile.m_58900_() && player.m_9236_().m_7702_(this.tile.m_58899_()) == this.tile && player.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)this.tile.m_58899_())) <= 64.0;
    }

    @Override
    public boolean needFullSync() {
        return this.tile.m_58904_() != null && this.tile.m_58904_().m_46467_() % 100L == 0L;
    }

    public void elementClicked(int element, byte button) {
        if (element < 0 || element >= this.tile.getGuiElements().size()) {
            throw new IllegalArgumentException("Invalid gui element ID: " + element);
        }
        this.tile.getGuiElements().get(element).handleClick(button, this.tile, this, this.getPlayer());
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.tile.stopInteracting(serverPlayer);
        }
    }
}

