/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import com.communi.suggestu.saecularia.caudices.core.block.IBlockWithWorldlyProperties;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.component.LightMachineComponent;
import fr.frinn.custommachinery.common.component.MachineComponentManager;
import fr.frinn.custommachinery.common.component.RedstoneMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.init.ConfigurationCardItem;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.network.SRefreshCustomMachineTilePacket;
import fr.frinn.custommachinery.common.util.MachineBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CustomMachineBlock
extends Block
implements EntityBlock,
IBlockWithWorldlyProperties {
    private static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> spawnPredicate = (state, level, pos, type) -> {
        CustomMachineBlock machineBlock;
        Block patt3253$temp;
        return state.m_60783_(level, pos, Direction.UP) && (patt3253$temp = state.m_60734_()) instanceof CustomMachineBlock && (machineBlock = (CustomMachineBlock)patt3253$temp).getLightEmission(state, level, pos) < 14;
    };
    public final String renderType;

    public static BlockBehaviour.Properties makeProperties(boolean occlusion) {
        if (occlusion) {
            return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60999_().m_60978_(3.5f).m_60988_().m_60922_(spawnPredicate);
        }
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60999_().m_60978_(3.5f).m_60955_().m_60988_().m_60922_(spawnPredicate);
    }

    public CustomMachineBlock(String renderType, boolean occlusion) {
        super(CustomMachineBlock.makeProperties(occlusion));
        this.renderType = renderType;
    }

    public CustomMachineBlock() {
        this("translucent", false);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)tile;
            if (player.m_21120_(hand).m_150930_((Item)Registration.CONFIGURATION_CARD_ITEM.get())) {
                return ConfigurationCardItem.pasteConfiguration(level, player, machine, player.m_21120_(hand));
            }
            if (machine.getComponentManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).map(h -> (FluidComponentHandler)h).map(fluidHandler -> fluidHandler.getCommonFluidHandler().interactWithFluidHandler(player, hand)).orElse(false).booleanValue()) {
                return InteractionResult.SUCCESS;
            }
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!machine.getGuiElements().isEmpty()) {
                    CustomMachineContainer.open(serverPlayer, machine);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        CustomMachineItem.getMachine(stack).ifPresent(machine -> {
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof CustomMachineTile) {
                CustomMachineTile machineTile = (CustomMachineTile)tile;
                machineTile.setId(machine.getId());
                if (placer != null) {
                    machineTile.setOwner(placer);
                }
                if (!level.m_5776_() && level.m_7654_() != null && placer != null && placer.m_21120_(InteractionHand.OFF_HAND) == stack) {
                    level.m_7654_().m_6937_((Runnable)new TickTask(1, () -> new SRefreshCustomMachineTilePacket(pos, machine.getId()).sendToChunkListeners(level.m_46745_(pos))));
                }
            }
        });
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity blockEntity;
        ResourceLocation id = (ResourceLocation)CustomMachinery.CUSTOM_BLOCK_MACHINES.inverse().get((Object)this);
        if (id != null && (blockEntity = level.m_7702_(pos)) instanceof CustomMachineTile) {
            CustomMachineTile machineTile = (CustomMachineTile)blockEntity;
            machineTile.setId(id);
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        CustomMachineTile machine;
        if (blockEntity instanceof CustomMachineTile && PlatformHelper.hasCorrectToolsForDrops(player, (BlockState)MachineBlockState.CACHE.getUnchecked((Object)(machine = (CustomMachineTile)blockEntity).getAppearance()))) {
            super.m_6240_(level, player, pos, state, blockEntity, tool);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (player.m_150110_().f_35937_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CustomMachineTile) {
                CustomMachineTile machine = (CustomMachineTile)blockEntity;
                machine.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).map(handler -> handler.getComponents().stream().filter(component -> component.getVariant().shouldDrop(machine.getComponentManager())).map(component -> component.getItemStack().m_41777_()).filter(stack -> !stack.m_41619_()).toList()).orElse(Collections.emptyList()).forEach(stack -> Block.m_49840_((Level)serverLevel, (BlockPos)pos, (ItemStack)stack));
            }
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        Object object = builder.m_287261_(LootContextParams.f_81462_);
        if (object instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)object;
            machine.getComponentManager().getComponentHandler((MachineComponentType)Registration.ITEM_MACHINE_COMPONENT.get()).ifPresent(handler -> handler.getComponents().stream().filter(component -> component.getVariant().shouldDrop(machine.getComponentManager())).map(component -> component.getItemStack().m_41777_()).filter(stack -> stack != ItemStack.f_41583_).forEach(drops::add));
            drops.add(CustomMachineItem.makeMachineItem(machine.getId()));
        }
        return drops;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return PlatformHelper.createMachineTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return Utils.createTickerHelper(type, (BlockEntityType)Registration.CUSTOM_MACHINE_TILE.get(), CustomMachineTile::clientTick);
        }
        return Utils.createTickerHelper(type, (BlockEntityType)Registration.CUSTOM_MACHINE_TILE.get(), CustomMachineTile::serverTick);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CustomMachineTile) {
            return ((CustomMachineTile)tile).getComponentManager().getComponent((MachineComponentType)Registration.REDSTONE_MACHINE_COMPONENT.get()).map(RedstoneMachineComponent::getComparatorInput).orElse(0);
        }
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CustomMachineTile) {
            return ((CustomMachineTile)tile).getComponentManager().getComponent((MachineComponentType)Registration.REDSTONE_MACHINE_COMPONENT.get()).map(RedstoneMachineComponent::getPowerOutput).orElse(0);
        }
        return 0;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CustomMachineTile) {
            return ((CustomMachineTile)tile).getComponentManager().getComponent((MachineComponentType)Registration.REDSTONE_MACHINE_COMPONENT.get()).map(RedstoneMachineComponent::getPowerOutput).orElse(0);
        }
        return 0;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return Optional.ofNullable(level.m_7702_(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> (CustomMachineTile)tile).map(CustomMachineTile::getAppearance).map(appearance -> Float.valueOf(Utils.getMachineBreakSpeed(appearance, level, pos, player))).orElseGet(() -> {
            float f = state.m_60800_(level, pos);
            if (f == -1.0f) {
                return Float.valueOf(0.0f);
            }
            int i = PlatformHelper.hasCorrectToolsForDrops(player, state) ? 30 : 100;
            return Float.valueOf(player.m_36281_(state) / f / (float)i);
        }).floatValue();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Optional.ofNullable(level.m_7702_(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> ((CustomMachineTile)tile).getAppearance().getCollisionShape().apply((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))).orElse(super.m_5939_(state, level, pos, context));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Optional.ofNullable(level.m_7702_(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> ((CustomMachineTile)tile).getAppearance().getShape().apply((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))).orElse(super.m_5940_(state, level, pos, context));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile customMachineTile = (CustomMachineTile)tile;
            CustomMachine machine = customMachineTile.getMachine();
            return CustomMachineItem.makeMachineItem(machine.getId());
        }
        return super.m_7397_(level, pos, state);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return Optional.ofNullable(level.m_7702_(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> Float.valueOf(((CustomMachineTile)tile).getAppearance().getResistance())).orElse(Float.valueOf(super.m_7325_())).floatValue();
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return Optional.ofNullable(level.m_7702_(pos)).filter(blockEntity -> blockEntity instanceof CustomMachineTile).map(tile -> ((CustomMachineTile)tile).getAppearance().getInteractionSound()).orElse(super.m_49962_(state));
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.m_49958_();
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CustomMachineTile) {
            MachineComponentManager manager = ((CustomMachineTile)tile).getComponentManager();
            return manager.getComponent((MachineComponentType)Registration.LIGHT_MACHINE_COMPONENT.get()).map(LightMachineComponent::getMachineLight).orElse(0);
        }
        return 0;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public float[] getBeaconColorMultiplier(BlockState blockState, LevelReader levelReader, BlockPos blockPos, BlockPos blockPos1) {
        return new float[0];
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return Optional.ofNullable(level.m_7702_(pos)).filter(blockEntity -> blockEntity instanceof CustomMachineTile).map(blockEntity -> (CustomMachineTile)blockEntity).map(machine -> PlatformHelper.hasCorrectToolsForDrops(player, (BlockState)MachineBlockState.CACHE.getUnchecked((Object)machine.getAppearance()))).orElse(player.m_36298_(state));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult hitResult, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile customMachineTile = (CustomMachineTile)tile;
            CustomMachine machine = customMachineTile.getMachine();
            return CustomMachineItem.makeMachineItem(machine.getId());
        }
        return super.m_7397_(level, pos, state);
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public boolean shouldCheckWeakPower(BlockState blockState, SignalGetter levelReader, BlockPos blockPos, Direction direction) {
        return true;
    }

    public DyeColor m_7988_() {
        return DyeColor.BLACK;
    }
}

