/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationCardItem
extends Item {
    private static final String MACHINE_ID = "machineId";
    private static final String SIDE_CONFIG = "sideConfig";

    public ConfigurationCardItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CustomMachineTile)) {
            return InteractionResult.FAIL;
        }
        CustomMachineTile machine = (CustomMachineTile)blockEntity;
        return this.copyConfiguration(level, player, machine, player.m_21120_(context.m_43724_()));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_()) {
            stack.m_41749_("custommachinery");
            player.m_213846_((Component)Component.m_237115_((String)"custommachinery.configuration_card.cleared").m_130940_(ChatFormatting.GREEN));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        ConfigurationCardItem.getMachineId(stack).flatMap(id -> Optional.ofNullable(CustomMachinery.MACHINES.get(id))).ifPresent(machine -> tooltip.add((Component)Component.m_237110_((String)"custommachinery.configuration_card.configured", (Object[])new Object[]{machine.getName()}).m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)Component.m_237115_((String)"custommachinery.configuration_card.copy").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"custommachinery.configuration_card.paste").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"custommachinery.configuration_card.reset").m_130940_(ChatFormatting.GOLD));
    }

    private InteractionResult copyConfiguration(Level level, Player player, CustomMachineTile machine, ItemStack stack) {
        if (!level.f_46443_ && player.m_6047_()) {
            ConfigurationCardItem.setMachineId(stack, machine.getId());
            for (ISideConfigComponent component : machine.getComponentManager().getConfigComponents()) {
                ConfigurationCardItem.serializeSideConfig(stack, component);
            }
            player.m_213846_((Component)Component.m_237115_((String)"custommachinery.configuration_card.copied").m_130940_(ChatFormatting.GREEN));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult pasteConfiguration(Level level, Player player, CustomMachineTile machine, ItemStack stack) {
        if (!level.f_46443_) {
            Optional<ResourceLocation> machineId = ConfigurationCardItem.getMachineId(stack);
            if (!machineId.map(id -> id.equals((Object)machine.getId())).orElse(false).booleanValue()) {
                player.m_213846_((Component)Component.m_237115_((String)"custommachinery.configuration_card.different_machine").m_130940_(ChatFormatting.RED));
                return InteractionResult.FAIL;
            }
            for (ISideConfigComponent component : machine.getComponentManager().getConfigComponents()) {
                ConfigurationCardItem.deserializeSideConfig(stack, component);
            }
            player.m_213846_((Component)Component.m_237115_((String)"custommachinery.configuration_card.pasted").m_130940_(ChatFormatting.GREEN));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static Optional<CompoundTag> getDataHolder(ItemStack stack) {
        return Optional.ofNullable(stack.m_41737_("custommachinery"));
    }

    private static Optional<ResourceLocation> getMachineId(ItemStack stack) {
        return ConfigurationCardItem.getDataHolder(stack).map(nbt -> ResourceLocation.m_135820_((String)nbt.m_128461_(MACHINE_ID)));
    }

    private static void setMachineId(ItemStack stack, ResourceLocation id) {
        stack.m_41698_("custommachinery").m_128359_(MACHINE_ID, id.toString());
    }

    private static void deserializeSideConfig(ItemStack stack, ISideConfigComponent component) {
        ConfigurationCardItem.getDataHolder(stack).ifPresent(nbt -> {
            CompoundTag sideConfig;
            if (nbt.m_128425_(SIDE_CONFIG, 10) && (sideConfig = nbt.m_128469_(SIDE_CONFIG)).m_128441_(component.getId())) {
                component.getConfig().deserialize(sideConfig.m_128423_(component.getId()));
            }
        });
    }

    private static void serializeSideConfig(ItemStack stack, ISideConfigComponent component) {
        CompoundTag sideConfig = stack.m_41698_("custommachinery").m_128469_(SIDE_CONFIG);
        if (!stack.m_41698_("custommachinery").m_128425_(SIDE_CONFIG, 10)) {
            stack.m_41698_("custommachinery").m_128365_(SIDE_CONFIG, (Tag)sideConfig);
        }
        sideConfig.m_128365_(component.getId(), component.getConfig().serialize());
        stack.m_41698_("custommachinery").m_128365_(SIDE_CONFIG, (Tag)sideConfig);
    }
}

