/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.crafting.AbstractRecipeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CustomMachineRecipeBuilder
extends AbstractRecipeBuilder<CustomMachineRecipe> {
    public static final NamedCodec<CustomMachineRecipeBuilder> CODEC = NamedCodec.record(recipeBuilderInstance -> recipeBuilderInstance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("machine").forGetter(AbstractRecipeBuilder::getMachine), NamedCodec.INT.fieldOf("time").forGetter(builder -> builder.time), IRequirement.CODEC.listOf().optionalFieldOf("requirements", Collections.emptyList()).forGetter(AbstractRecipeBuilder::getRequirements), IRequirement.CODEC.listOf().optionalFieldOf("jei", Collections.emptyList()).forGetter(AbstractRecipeBuilder::getJeiRequirements), NamedCodec.INT.optionalFieldOf("priority", 0).forGetter(AbstractRecipeBuilder::getPriority), NamedCodec.INT.optionalFieldOf("jeiPriority", 0).forGetter(AbstractRecipeBuilder::getJeiPriority), NamedCodec.BOOL.optionalFieldOf("error", true).forGetter(builder -> !builder.resetOnError), NamedCodec.BOOL.optionalFieldOf("hidden", false).forGetter(AbstractRecipeBuilder::isHidden), MachineAppearance.CODEC.optionalFieldOf("appearance").forGetter(builder -> Optional.ofNullable(builder.appearance).map(MachineAppearance::getProperties)), IGuiElement.CODEC.listOf().optionalFieldOf("gui", Collections.emptyList()).forGetter(builder -> builder.guiElements)).apply((Applicative)recipeBuilderInstance, (machine, time, requirements, jeiRequirements, priority, jeiPriority, error, hidden, appearance, guiElements) -> {
        CustomMachineRecipeBuilder builder = new CustomMachineRecipeBuilder((ResourceLocation)machine, (int)time);
        requirements.forEach(builder::withRequirement);
        jeiRequirements.forEach(builder::withJeiRequirement);
        builder.withPriority((int)priority);
        builder.withJeiPriority((int)jeiPriority);
        if (!error.booleanValue()) {
            builder.setResetOnError();
        }
        if (hidden.booleanValue()) {
            builder.hide();
        }
        appearance.ifPresent(map -> builder.withAppearance(new MachineAppearance((Map<MachineAppearanceProperty<?>, Object>)map)));
        guiElements.forEach(builder::withGuiElement);
        return builder;
    }), "Machine recipe builder");
    private final int time;
    private boolean resetOnError = false;
    @Nullable
    private MachineAppearance appearance = null;
    private List<IGuiElement> guiElements = new ArrayList<IGuiElement>();

    public CustomMachineRecipeBuilder(ResourceLocation machine, int time) {
        super(machine);
        this.time = time;
    }

    public CustomMachineRecipeBuilder(CustomMachineRecipe recipe) {
        super(recipe);
        this.time = recipe.getRecipeTime();
        this.resetOnError = recipe.shouldResetOnError();
        this.appearance = recipe.getAppearance();
        this.guiElements = recipe.getGuiElements();
    }

    public CustomMachineRecipeBuilder setResetOnError() {
        this.resetOnError = true;
        return this;
    }

    public CustomMachineRecipeBuilder withAppearance(MachineAppearance appearance) {
        this.appearance = appearance;
        return this;
    }

    public CustomMachineRecipeBuilder withGuiElement(IGuiElement element) {
        this.guiElements.add(element);
        return this;
    }

    @Override
    public CustomMachineRecipe build(ResourceLocation id) {
        return new CustomMachineRecipe(id, this.getMachine(), this.time, this.getRequirements(), this.getJeiRequirements(), this.getPriority(), this.getJeiPriority(), this.resetOnError, this.isHidden(), this.appearance, this.guiElements);
    }

    public String toString() {
        return "CustomMachineRecipe{machine=" + this.getMachine() + ", time=" + this.time + ", requirements=" + this.getRequirements().stream().map(requirement -> requirement.getType().getId()).toList() + ", jeiRequirements=" + this.getJeiRequirements().stream().map(requirement -> requirement.getType().getId()).toList() + ", priority=" + this.getPriority() + ", jeiPriority=" + this.getJeiPriority() + ", resetOnError=" + this.resetOnError + ", hidden=" + this.isHidden() + "}";
    }
}

