/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.craft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class CustomCraftRecipeSerializer
implements RecipeSerializer<CustomCraftRecipe> {
    public CustomCraftRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        ICustomMachineryAPI.INSTANCE.logger().info("Parsing craft recipe json: {}", (Object)recipeId);
        DataResult<Pair<CustomCraftRecipeBuilder, JsonObject>> result = CustomCraftRecipeBuilder.CODEC.decode(JsonOps.INSTANCE, json);
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Successfully read craft recipe json: {}", (Object)recipeId);
            return ((CustomCraftRecipeBuilder)((Pair)result.result().get()).getFirst()).build(recipeId);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing craft recipe json: {}, skipping...\n{}", (Object)recipeId, (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new JsonParseException("Error while parsing Custom Machine Craft Recipe json: " + recipeId + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when parsing Custom Machine Craft Recipe json: " + recipeId + "This can't happen");
    }

    @Nullable
    public CustomCraftRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ICustomMachineryAPI.INSTANCE.logger().info("Receiving craft recipe: {} from server.", (Object)recipeId);
        DataResult<CustomCraftRecipeBuilder> result = CustomCraftRecipeBuilder.CODEC.read(NbtOps.f_128958_, buffer.m_130261_());
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Sucessfully received craft recipe: {} from server.", (Object)recipeId);
            return ((CustomCraftRecipeBuilder)result.result().get()).build(recipeId);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing craft recipe json: {}, skipping...\n{}", (Object)recipeId, (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new IllegalArgumentException("Error while receiving Custom Machine Craft Recipe from server: " + recipeId + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when receiving Custom Machine Craft Recipe: " + recipeId + "from server. This can't happen");
    }

    public void toNetwork(FriendlyByteBuf buffer, CustomCraftRecipe recipe) {
        ICustomMachineryAPI.INSTANCE.logger().info("Sending craft recipe: {} to clients", (Object)recipe.m_6423_());
        DataResult result = CustomCraftRecipeBuilder.CODEC.encodeStart(NbtOps.f_128958_, new CustomCraftRecipeBuilder(recipe));
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Sucessfully send craft recipe: {} to clients.", (Object)recipe.m_6423_());
            buffer.m_130079_((CompoundTag)result.result().get());
            return;
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while sending craft recipe: {} to clients.%n{}", (Object)recipe.m_6423_(), (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new IllegalArgumentException("Error while sending Custom Machine Craft Recipe to clients: " + recipe.m_6423_() + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when sending Custom Machine Craft Recipe: " + recipe.m_6423_() + "to clients. This can't happen");
    }
}

