/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;

public class WeatherMachineComponent
extends AbstractMachineComponent {
    public WeatherMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public MachineComponentType<WeatherMachineComponent> getType() {
        return (MachineComponentType)Registration.WEATHER_MACHINE_COMPONENT.get();
    }

    public boolean hasWeather(WeatherType weather, boolean onTile) {
        Level world = this.getManager().getLevel();
        BlockPos pos = this.getManager().getTile().m_58899_();
        if (onTile) {
            if (weather == WeatherType.RAIN) {
                return world.m_46758_(pos.m_7494_());
            }
            if (weather == WeatherType.SNOW) {
                return world.m_46471_() && world.m_45527_(pos.m_7494_()) && world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos.m_7494_()).m_123342_() > pos.m_7494_().m_123342_() && ((Biome)world.m_204166_(pos).m_203334_()).m_198904_(pos.m_7494_());
            }
            if (weather == WeatherType.THUNDER) {
                return world.m_46758_(pos.m_7494_()) && world.m_46470_();
            }
            if (weather == WeatherType.CLEAR) {
                return !world.m_46471_();
            }
        } else {
            if (weather == WeatherType.RAIN) {
                return world.m_46471_();
            }
            if (weather == WeatherType.SNOW) {
                return world.m_46471_() && world.m_45527_(pos.m_7494_()) && world.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos.m_7494_()).m_123342_() > pos.m_7494_().m_123342_() && ((Biome)world.m_204166_(pos).m_203334_()).m_198904_(pos.m_7494_());
            }
            if (weather == WeatherType.THUNDER) {
                return world.m_46470_();
            }
            if (weather == WeatherType.CLEAR) {
                return !world.m_46471_();
            }
        }
        return false;
    }

    public static enum WeatherType {
        CLEAR,
        RAIN,
        SNOW,
        THUNDER;

        public static final NamedCodec<WeatherType> CODEC;

        public static WeatherType value(String value) {
            return WeatherType.valueOf(value.toUpperCase(Locale.ENGLISH));
        }

        public Component getText() {
            return Component.m_237115_((String)("custommachinery.component.weather." + this.toString().toLowerCase(Locale.ENGLISH)));
        }

        static {
            CODEC = NamedCodec.enumCodec(WeatherType.class);
        }
    }
}

