/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.BlockStructure;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class StructureMachineComponent
extends AbstractMachineComponent {
    public StructureMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public MachineComponentType<StructureMachineComponent> getType() {
        return (MachineComponentType)Registration.STRUCTURE_MACHINE_COMPONENT.get();
    }

    public boolean checkStructure(BlockStructure pattern) {
        return pattern.match((LevelReader)this.getManager().getTile().m_58904_(), this.getManager().getTile().m_58899_(), (Direction)this.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
    }

    public void destroyStructure(BlockStructure pattern, boolean drops) {
        pattern.getBlocks((Direction)this.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).forEach((pos, ingredient) -> {
            if (!ingredient.test(PartialBlockState.MACHINE) && !ingredient.test(PartialBlockState.ANY)) {
                this.getManager().getLevel().m_46961_(pos.m_121955_((Vec3i)this.getManager().getTile().m_58899_()), drops);
            }
        });
    }

    public void placeStructure(BlockStructure pattern, boolean drops) {
        pattern.getBlocks((Direction)this.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).forEach((pos, ingredient) -> {
            BlockPos worldPos = pos.m_121955_((Vec3i)this.getManager().getTile().m_58899_());
            if (pos != BlockPos.f_121853_ && !ingredient.test(PartialBlockState.ANY)) {
                if (!this.getManager().getLevel().m_8055_(worldPos).m_60795_()) {
                    this.getManager().getLevel().m_46961_(worldPos, drops);
                }
                this.setBlock(this.getManager().getLevel(), worldPos, (PartialBlockState)ingredient.getAll().get(0));
            }
        });
    }

    private void setBlock(Level world, BlockPos pos, PartialBlockState state) {
        world.m_46597_(pos, state.getBlockState());
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null && state.getNbt() != null && !state.getNbt().m_128456_()) {
            CompoundTag nbt = state.getNbt().m_6426_();
            nbt.m_128405_("x", pos.m_123341_());
            nbt.m_128405_("y", pos.m_123342_());
            nbt.m_128405_("z", pos.m_123343_());
            tile.m_142466_(nbt);
        }
    }
}

