/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.mojang.datafixers.kinds.Applicative;
import dev.architectury.fluid.FluidStack;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.FluidStackSyncable;
import fr.frinn.custommachinery.common.network.syncable.SideConfigSyncable;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class FluidMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
ISideConfigComponent {
    private final String id;
    private final long capacity;
    private final long maxInput;
    private final long maxOutput;
    private final List<IIngredient<Fluid>> filter;
    private final boolean whitelist;
    private final SideConfig config;
    private final boolean unique;
    private FluidStack fluidStack = FluidStack.empty();

    public FluidMachineComponent(IMachineComponentManager manager, ComponentIOMode mode, String id, long capacity, long maxInput, long maxOutput, List<IIngredient<Fluid>> filter, boolean whitelist, SideConfig.Template configTemplate, boolean unique) {
        super(manager, mode);
        this.id = id;
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.filter = filter;
        this.whitelist = whitelist;
        this.config = configTemplate.build(this);
        this.unique = unique;
    }

    public MachineComponentType<FluidMachineComponent> getType() {
        return (MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public long getMaxOutput() {
        return this.maxOutput;
    }

    @Override
    public SideConfig getConfig() {
        return this.config;
    }

    @Override
    public void serialize(CompoundTag nbt) {
        if (!this.fluidStack.isEmpty()) {
            nbt.m_128365_("stack", (Tag)this.fluidStack.write(new CompoundTag()));
        }
        nbt.m_128365_("config", this.config.serialize());
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        if (nbt.m_128425_("stack", 10)) {
            this.fluidStack = FluidStack.read((CompoundTag)nbt.m_128469_("stack"));
        }
        if (nbt.m_128441_("config")) {
            this.config.deserialize(nbt.m_128423_("config"));
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(FluidStackSyncable.create(() -> this.fluidStack, fluidStack -> {
            this.fluidStack = fluidStack;
        }));
        container.accept(SideConfigSyncable.create(this::getConfig, this.config::set));
    }

    @Override
    public int getComparatorInput() {
        return (int)(15.0 * ((double)this.fluidStack.getAmount() / (double)this.capacity));
    }

    public FluidStack getFluidStack() {
        return this.fluidStack.copy();
    }

    public void setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack.copy();
        this.getManager().markDirty();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getRemainingSpace() {
        if (!this.fluidStack.isEmpty()) {
            return Math.min(this.capacity - this.fluidStack.getAmount(), this.getMaxInput());
        }
        return Math.min(this.capacity, this.getMaxInput());
    }

    public boolean isFluidValid(@NotNull FluidStack stack) {
        if (this.unique && this.fluidStack.isEmpty() && this.getManager().getComponentHandler((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()).stream().flatMap(handler -> handler.getComponents().stream()).anyMatch(component -> component != this && component.getFluidStack().isFluidEqual(stack))) {
            return false;
        }
        if (this.filter.stream().anyMatch(ingredient -> ingredient.test(stack.getFluid())) != this.whitelist) {
            return false;
        }
        return this.fluidStack.isEmpty() || stack.isFluidEqual(this.fluidStack);
    }

    public long insert(Fluid fluid, long amount, CompoundTag nbt, boolean simulate) {
        if (amount <= 0L) {
            return 0L;
        }
        if (this.fluidStack.isEmpty()) {
            amount = Math.min(amount, this.getMaxInput());
            if (!simulate) {
                this.fluidStack = FluidStack.create((Fluid)fluid, (long)amount, (CompoundTag)nbt);
                this.getManager().markDirty();
            }
        } else {
            amount = Math.min(Math.min(this.getRemainingSpace(), this.getMaxInput()), amount);
            if (!simulate) {
                this.fluidStack.grow(amount);
                this.getManager().markDirty();
            }
        }
        return amount;
    }

    public FluidStack extract(long amount, boolean simulate) {
        if (amount <= 0L || this.fluidStack.isEmpty()) {
            return FluidStack.empty();
        }
        amount = Utils.clamp(amount, 0L, Math.min(this.fluidStack.getAmount(), this.getMaxOutput()));
        FluidStack removed = FluidStack.create((Fluid)this.fluidStack.getFluid(), (long)amount, (CompoundTag)this.fluidStack.getTag());
        if (!simulate) {
            this.fluidStack.shrink(amount);
            this.getManager().markDirty();
        }
        return removed;
    }

    public long getRecipeRemainingSpace() {
        if (!this.fluidStack.isEmpty()) {
            return this.capacity - this.fluidStack.getAmount();
        }
        return this.capacity;
    }

    public void recipeInsert(Fluid fluid, long amount, CompoundTag nbt) {
        if (amount <= 0L) {
            return;
        }
        if (this.fluidStack.isEmpty()) {
            this.fluidStack = FluidStack.create((Fluid)fluid, (long)amount, (CompoundTag)nbt);
        } else {
            amount = Utils.clamp(amount, 0L, this.getRecipeRemainingSpace());
            this.fluidStack.grow(amount);
        }
        this.getManager().markDirty();
    }

    public void recipeExtract(long amount) {
        if (amount <= 0L) {
            return;
        }
        amount = Utils.clamp(amount, 0L, this.fluidStack.getAmount());
        this.fluidStack.shrink(amount);
        this.getManager().markDirty();
    }

    public record Template(String id, long capacity, long maxInput, long maxOutput, List<IIngredient<Fluid>> filter, boolean whitelist, ComponentIOMode mode, SideConfig.Template config, boolean unique) implements IMachineComponentTemplate<FluidMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(fluidMachineComponentTemplate -> fluidMachineComponentTemplate.group(NamedCodec.STRING.fieldOf("id").forGetter(template -> template.id), NamedCodec.LONG.fieldOf("capacity").forGetter(template -> template.capacity), NamedCodec.LONG.optionalFieldOf("maxInput").forGetter(template -> template.maxInput == template.capacity ? Optional.empty() : Optional.of(template.maxInput)), NamedCodec.LONG.optionalFieldOf("maxOutput").forGetter(template -> template.maxOutput == template.capacity ? Optional.empty() : Optional.of(template.maxOutput)), IIngredient.FLUID.listOf().optionalFieldOf("filter", Collections.emptyList()).forGetter(template -> template.filter), NamedCodec.BOOL.optionalFieldOf("whitelist", false).forGetter(template -> template.whitelist), ComponentIOMode.CODEC.optionalFieldOf("mode", ComponentIOMode.BOTH).forGetter(template -> template.mode), SideConfig.Template.CODEC.optionalFieldOf("config").forGetter(template -> template.config == template.mode.getBaseConfig() ? Optional.empty() : Optional.of(template.config)), NamedCodec.BOOL.optionalFieldOf("unique", false).forGetter(template -> template.unique)).apply((Applicative)fluidMachineComponentTemplate, (id, capacity, maxInput, maxOutput, filter, whitelist, mode, config, unique) -> new Template((String)id, (long)capacity, maxInput.orElse(capacity), maxOutput.orElse(capacity), (List<IIngredient<Fluid>>)filter, (boolean)whitelist, (ComponentIOMode)((Object)((Object)mode)), config.orElse(mode.getBaseConfig()), (boolean)unique)), "Fluid machine component");

        @Override
        public MachineComponentType<FluidMachineComponent> getType() {
            return (MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            if (this.mode != ComponentIOMode.BOTH && isInput != this.mode.isInput()) {
                return false;
            }
            if (ingredient instanceof FluidStack) {
                FluidStack stack = (FluidStack)ingredient;
                return this.filter.stream().flatMap(f -> f.getAll().stream()).anyMatch(f -> f == stack.getFluid()) == this.whitelist;
            }
            if (ingredient instanceof List) {
                List list = (List)ingredient;
                return list.stream().allMatch(object -> {
                    if (object instanceof FluidStack) {
                        FluidStack stack = (FluidStack)object;
                        return this.filter.stream().flatMap(f -> f.getAll().stream()).anyMatch(f -> f == stack.getFluid()) == this.whitelist;
                    }
                    return false;
                });
            }
            return false;
        }

        @Override
        public FluidMachineComponent build(IMachineComponentManager manager) {
            return new FluidMachineComponent(manager, this.mode, this.id, this.capacity, this.maxInput, this.maxOutput, this.filter, this.whitelist, this.config, this.unique);
        }
    }
}

