/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.MachineList;
import fr.frinn.custommachinery.common.util.TaskDelayer;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkloadMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ITickableComponent {
    private boolean active;
    private int radius;
    private int tempo = -1;
    private static final TicketType<BlockPos> MACHINE_CHUNKLOADER = TicketType.m_9465_((String)"custom_machine", Vec3i::compareTo, (int)0);

    public ChunkloadMachineComponent(IMachineComponentManager manager, boolean active, int radius) {
        super(manager, ComponentIOMode.NONE);
        this.active = active;
        this.radius = radius;
    }

    public ChunkloadMachineComponent(IMachineComponentManager manager) {
        this(manager, false, 1);
    }

    public MachineComponentType<ChunkloadMachineComponent> getType() {
        return (MachineComponentType)Registration.CHUNKLOAD_MACHINE_COMPONENT.get();
    }

    @Override
    public void onRemoved() {
        Level level = this.getManager().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!this.getManager().getTile().isUnloaded()) {
                this.setInactive(level2);
            }
        }
    }

    @Override
    public void init() {
        Level level;
        if (this.active && (level = this.getManager().getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ChunkPos pos = new ChunkPos(this.getManager().getTile().m_58899_());
            if (level2.m_6522_(pos.f_45578_, pos.f_45579_, ChunkStatus.f_62314_, false) instanceof LevelChunk) {
                this.setActive(level2, this.radius);
            } else {
                TaskDelayer.enqueue(1, () -> this.setActive(level2, this.radius));
            }
        }
    }

    @Override
    public void serverTick() {
        if (this.tempo >= 0 && this.tempo-- == 0) {
            this.setInactive((ServerLevel)this.getManager().getLevel());
        }
    }

    @Override
    public void serialize(CompoundTag nbt) {
        nbt.m_128379_("active", this.active);
        nbt.m_128405_("radius", this.radius);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        if (nbt.m_128425_("active", 1)) {
            this.active = nbt.m_128471_("active");
        }
        if (nbt.m_128425_("radius", 3)) {
            this.radius = nbt.m_128451_("radius");
        }
    }

    public void setActive(ServerLevel level, int radius) {
        if (this.active) {
            this.setInactive(level);
        }
        this.active = true;
        this.radius = radius;
        BlockPos machinePos = this.getManager().getTile().m_58899_();
        ChunkPos chunk = new ChunkPos(machinePos);
        level.m_8602_(chunk.f_45578_, chunk.f_45579_, true);
        level.m_7726_().m_8387_(MACHINE_CHUNKLOADER, chunk, radius + 1, (Object)machinePos);
    }

    public void setActiveWithTempo(ServerLevel level, int radius, int tempo) {
        this.tempo = Math.max(this.tempo, tempo);
        if (!this.active || this.radius < radius) {
            this.setActive(level, radius);
        }
    }

    public void setInactive(ServerLevel level) {
        this.active = false;
        BlockPos machinePos = this.getManager().getTile().m_58899_();
        ChunkPos chunk = new ChunkPos(machinePos);
        if (MachineList.findInSameChunk(this.getManager().getTile()).isEmpty()) {
            level.m_8602_(chunk.f_45578_, chunk.f_45579_, false);
        }
        level.m_7726_().m_8438_(MACHINE_CHUNKLOADER, chunk, this.radius + 1, (Object)machinePos);
    }

    public boolean isActive() {
        return this.active;
    }

    public int getRadius() {
        return this.radius;
    }

    public record Template(int radius) implements IMachineComponentTemplate<ChunkloadMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group(NamedCodec.intRange(1, 32).optionalFieldOf("radius", 1).forGetter(template -> template.radius)).apply((Applicative)templateInstance, Template::new), "Chunkload machine component template");

        @Override
        public MachineComponentType<ChunkloadMachineComponent> getType() {
            return (MachineComponentType)Registration.CHUNKLOAD_MACHINE_COMPONENT.get();
        }

        @Override
        public String getId() {
            return "chunkload";
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return false;
        }

        @Override
        public ChunkloadMachineComponent build(IMachineComponentManager manager) {
            return new ChunkloadMachineComponent(manager, true, this.radius);
        }
    }
}

