/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachineJsonReloadListener;
import fr.frinn.custommachinery.common.network.SOpenCreationScreenPacket;
import fr.frinn.custommachinery.common.network.SOpenEditScreenPacket;
import fr.frinn.custommachinery.common.network.SOpenFilePacket;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class CMCommand {
    public static final SuggestionProvider<CommandSourceStack> ALL_MACHINES = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("custommachinery", "all_machines"), (commandContext, suggestionsBuilder) -> CMCommand.suggestCMResource(CustomMachinery.MACHINES.keySet(), suggestionsBuilder));

    public static LiteralArgumentBuilder<CommandSourceStack> register(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)name).then(CMCommand.logging())).then(CMCommand.reload())).then(CMCommand.create())).then(CMCommand.edit());
    }

    private static ArgumentBuilder<CommandSourceStack, ?> logging() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"log").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
            Entity patt2181$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (patt2181$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt2181$temp;
                new SOpenFilePacket(new File("logs/custommachinery.log").toURI().toString()).sendTo(player);
            }
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> reload() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
            Entity patt2637$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (patt2637$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt2637$temp;
                CMCommand.reloadMachines(player.f_8924_, player);
            }
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> create() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"create").requires(cs -> cs.m_6761_(2) && cs.m_230897_())).executes(ctx -> {
            Entity patt3056$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (patt3056$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt3056$temp;
                new SOpenCreationScreenPacket().sendTo(player);
            }
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> edit() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"edit").requires(cs -> cs.m_6761_(2) && cs.m_230897_())).then(Commands.m_82129_((String)"machine", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ALL_MACHINES).executes(ctx -> {
            Entity patt3626$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (patt3626$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt3626$temp;
                new SOpenEditScreenPacket(ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"machine")).sendTo(player);
            }
            return 0;
        }));
    }

    public static void reloadMachines(MinecraftServer server, @Nullable ServerPlayer player) {
        new CustomMachineJsonReloadListener().m_5540_(CompletableFuture::completedFuture, server.m_177941_(), (ProfilerFiller)InactiveProfiler.f_18554_, (ProfilerFiller)InactiveProfiler.f_18554_, (Executor)server, (Executor)server).thenRun(() -> {
            if (player != null) {
                player.m_213846_((Component)Component.m_237115_((String)"custommachinery.command.reload").m_130940_(ChatFormatting.GRAY));
            }
        });
    }

    private static CompletableFuture<Suggestions> suggestCMResource(Iterable<ResourceLocation> resources, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        boolean bl = string.indexOf(58) > -1;
        for (ResourceLocation object : resources) {
            if (bl) {
                String string2 = object.toString();
                if (!SharedSuggestionProvider.m_82949_((String)string, (String)string2)) continue;
                builder.suggest(object.toString());
                continue;
            }
            if (!SharedSuggestionProvider.m_82949_((String)string, (String)object.m_135827_()) && (!object.m_135827_().equals("custommachinery") || !SharedSuggestionProvider.m_82949_((String)string, (String)object.m_135815_()))) continue;
            builder.suggest(object.toString());
        }
        return builder.buildFuture();
    }
}

