/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.lwjgl.opengl.GL11;

public class SuggestedEditBox
extends EditBox {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    private final List<String> possibleSuggestions = new ArrayList<String>();
    private final int suggestionLineLimit;
    private final int baseWidth;
    private SuggestionsList suggestionsList;
    private Suggestions suggestions;
    private List<Suggestion> sorted;
    private int baseX;
    private boolean anchorToBottom = false;

    public SuggestedEditBox(Font font, int x, int y, int width, int height, Component message, int suggestionLineLimit) {
        super(font, x, y, width, height, message);
        this.suggestionLineLimit = suggestionLineLimit;
        this.baseWidth = width;
        this.m_94151_(s -> {});
        this.updateSuggestions();
    }

    public void addSuggestions(List<String> suggestions) {
        this.possibleSuggestions.addAll(suggestions);
        this.updateSuggestions();
    }

    public void clearSuggestions() {
        this.possibleSuggestions.clear();
        this.updateSuggestions();
    }

    public List<Suggestion> getSuggestions() {
        return this.sorted != null ? this.sorted : Collections.emptyList();
    }

    public void updateSuggestions() {
        SuggestionsBuilder builder = new SuggestionsBuilder(this.m_94155_(), 0);
        this.possibleSuggestions.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        this.suggestions = builder.build();
        this.sorted = this.sortSuggestions(this.suggestions);
    }

    public void showSuggestions(boolean narrateFirstSuggestion) {
        if (this.suggestions != null && !this.suggestions.isEmpty()) {
            int i = 0;
            for (Suggestion suggestion : this.suggestions.getList()) {
                i = Math.max(i, Minecraft.m_91087_().f_91062_.m_92895_(suggestion.getText()));
            }
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof BaseScreen) {
                BaseScreen baseScreen = (BaseScreen)screen;
                i = Mth.m_14045_((int)i, (int)0, (int)baseScreen.xSize);
            }
            int k = this.m_252907_() + (this.anchorToBottom ? 0 : this.f_93619_);
            this.suggestionsList = new SuggestionsList(this.m_252754_() + 4, k, i, this.sortSuggestions(this.suggestions), narrateFirstSuggestion, this.anchorToBottom, this.suggestionLineLimit);
        }
    }

    public void hideSuggestions() {
        this.suggestionsList = null;
    }

    public void setAnchorToBottom() {
        this.anchorToBottom = true;
    }

    private List<Suggestion> sortSuggestions(Suggestions suggestions) {
        String string = this.m_94155_().substring(0, this.m_94207_());
        int i = SuggestedEditBox.getLastWordIndex(string);
        String string2 = string.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (Suggestion suggestion : suggestions.getList()) {
            if (suggestion.getText().startsWith(string2) || suggestion.getText().startsWith("minecraft:" + string2)) {
                list.add(suggestion);
                continue;
            }
            list2.add(suggestion);
        }
        return list;
    }

    private static int getLastWordIndex(String text) {
        if (Strings.isNullOrEmpty((String)text)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = WHITESPACE_PATTERN.matcher(text);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    public void m_94151_(Consumer<String> responder) {
        super.m_94151_(s -> {
            this.updateSuggestions();
            this.showSuggestions(true);
            responder.accept((String)s);
        });
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
        if (!focused) {
            this.hideSuggestions();
            this.m_252865_(this.baseX);
            this.m_93674_(this.baseWidth);
        } else if (this.suggestionsList != null) {
            this.baseX = this.m_252754_();
            this.showSuggestions(false);
            this.m_252865_(this.suggestionsList.rect.m_110085_());
            this.m_93674_(Minecraft.m_91087_().m_91268_().m_85443_() - this.m_252754_());
            this.m_94198_();
        }
    }

    public void m_252865_(int x) {
        super.m_252865_(x);
        if (this.suggestionsList != null) {
            this.suggestionsList.rect.m_173047_(Math.min(x + 3, Minecraft.m_91087_().m_91268_().m_85445_() - this.m_5711_()));
        }
    }

    public void m_253211_(int y) {
        super.m_253211_(y);
        if (this.suggestionsList != null) {
            int yPos = this.m_252907_() + this.f_93619_ + this.suggestionLineLimit * 12;
            this.suggestionsList.rect.m_173054_(this.suggestionsList.anchorToBottom ? yPos - 3 - Math.min(this.suggestionsList.suggestionList.size(), this.suggestionLineLimit) * 12 : yPos);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.suggestionsList != null) {
            boolean scissor = GL11.glIsEnabled((int)3089);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            if (scissor) {
                GlStateManager._disableScissorTest();
            }
            this.suggestionsList.render(guiGraphics, mouseX, mouseY);
            if (scissor) {
                GlStateManager._enableScissorTest();
            }
            guiGraphics.m_280168_().m_85849_();
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.suggestionsList != null && this.suggestionsList.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (Minecraft.m_91087_().f_91080_ != null && Minecraft.m_91087_().f_91080_.m_7222_() == this && keyCode == 258) {
            this.showSuggestions(true);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.suggestionsList != null && this.suggestionsList.mouseScrolled(Mth.m_14008_((double)delta, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.suggestionsList != null && this.suggestionsList.mouseClicked((int)mouseX, (int)mouseY, mouseButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public class SuggestionsList {
        private final Rect2i rect;
        private final String originalContents;
        private final List<Suggestion> suggestionList;
        private final int suggestionLineLimit;
        private final int lineStartOffset = 1;
        private final boolean anchorToBottom;
        private final int fillColor = -805306368;
        private final Font font;
        private int offset;
        private int current;
        private Vec2 lastMouse;
        private boolean tabCycles;
        private int lastNarratedEntry;
        private boolean keepSuggestions;

        SuggestionsList(int xPos, int yPos, int width, List<Suggestion> suggestionList, boolean narrateFirstSuggestion, boolean anchorToBottom, int suggestionLineLimit) {
            this.font = Minecraft.m_91087_().f_91062_;
            this.lastMouse = Vec2.f_82462_;
            this.suggestionLineLimit = suggestionLineLimit;
            this.anchorToBottom = anchorToBottom;
            int i = Math.min(xPos + 3, Minecraft.m_91087_().m_91268_().m_85445_() - width);
            int j = this.anchorToBottom ? yPos - 3 - Math.min(suggestionList.size(), this.suggestionLineLimit) * 12 : yPos;
            this.rect = new Rect2i(i, j, width + 1, Math.min(suggestionList.size(), this.suggestionLineLimit) * 12);
            this.originalContents = SuggestedEditBox.this.m_94155_();
            this.lastNarratedEntry = narrateFirstSuggestion ? -1 : 0;
            this.suggestionList = suggestionList;
            this.select(0);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            Message message;
            int i = Math.min(this.suggestionList.size(), this.suggestionLineLimit);
            int j = -5592406;
            boolean bl = this.offset > 0;
            boolean bl2 = this.suggestionList.size() > this.offset + i;
            boolean bl3 = bl || bl2;
            boolean bl4 = this.lastMouse.f_82470_ != (float)mouseX || this.lastMouse.f_82471_ != (float)mouseY;
            boolean bl5 = bl4;
            if (bl4) {
                this.lastMouse = new Vec2((float)mouseX, (float)mouseY);
            }
            if (bl3) {
                int k;
                guiGraphics.m_280509_(this.rect.m_110085_(), this.rect.m_110086_() - 1, this.rect.m_110085_() + this.rect.m_110090_(), this.rect.m_110086_(), this.fillColor);
                guiGraphics.m_280509_(this.rect.m_110085_(), this.rect.m_110086_() + this.rect.m_110091_(), this.rect.m_110085_() + this.rect.m_110090_(), this.rect.m_110086_() + this.rect.m_110091_() + 1, this.fillColor);
                if (bl) {
                    for (k = 0; k < this.rect.m_110090_(); ++k) {
                        if (k % 2 != 0) continue;
                        guiGraphics.m_280509_(this.rect.m_110085_() + k, this.rect.m_110086_() - 1, this.rect.m_110085_() + k + 1, this.rect.m_110086_(), -1);
                    }
                }
                if (bl2) {
                    for (k = 0; k < this.rect.m_110090_(); ++k) {
                        if (k % 2 != 0) continue;
                        guiGraphics.m_280509_(this.rect.m_110085_() + k, this.rect.m_110086_() + this.rect.m_110091_(), this.rect.m_110085_() + k + 1, this.rect.m_110086_() + this.rect.m_110091_() + 1, -1);
                    }
                }
            }
            boolean bl52 = false;
            for (int l = 0; l < i; ++l) {
                Suggestion suggestion = this.suggestionList.get(l + this.offset);
                guiGraphics.m_280509_(this.rect.m_110085_(), this.rect.m_110086_() + 12 * l, this.rect.m_110085_() + this.rect.m_110090_(), this.rect.m_110086_() + 12 * l + 12, this.fillColor);
                if (mouseX > this.rect.m_110085_() && mouseX < this.rect.m_110085_() + this.rect.m_110090_() && mouseY > this.rect.m_110086_() + 12 * l && mouseY < this.rect.m_110086_() + 12 * l + 12) {
                    if (bl4) {
                        this.select(l + this.offset);
                    }
                    bl52 = true;
                }
                guiGraphics.m_280488_(this.font, suggestion.getText(), this.rect.m_110085_() + 1, this.rect.m_110086_() + 2 + 12 * l, l + this.offset == this.current ? -256 : -5592406);
            }
            if (bl52 && (message = this.suggestionList.get(this.current).getTooltip()) != null) {
                guiGraphics.m_280557_(this.font, ComponentUtils.m_130729_((Message)message), mouseX, mouseY);
            }
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
            if (!this.rect.m_110087_(mouseX, mouseY)) {
                return false;
            }
            int i = (mouseY - this.rect.m_110086_()) / 12 + this.offset;
            if (i >= 0 && i < this.suggestionList.size()) {
                this.select(i);
                this.useSuggestion();
            }
            return true;
        }

        public boolean mouseScrolled(double delta) {
            int j;
            int i = (int)(Minecraft.m_91087_().f_91067_.m_91589_() * (double)Minecraft.m_91087_().m_91268_().m_85445_() / (double)Minecraft.m_91087_().m_91268_().m_85443_());
            if (this.rect.m_110087_(i, j = (int)(Minecraft.m_91087_().f_91067_.m_91594_() * (double)Minecraft.m_91087_().m_91268_().m_85446_() / (double)Minecraft.m_91087_().m_91268_().m_85444_()))) {
                this.offset = Mth.m_14045_((int)((int)((double)this.offset - delta)), (int)0, (int)Math.max(this.suggestionList.size() - this.suggestionLineLimit, 0));
                return true;
            }
            return false;
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return switch (keyCode) {
                case 265 -> {
                    this.cycle(-1);
                    this.tabCycles = false;
                    yield true;
                }
                case 264 -> {
                    this.cycle(1);
                    this.tabCycles = false;
                    yield true;
                }
                case 258 -> {
                    if (this.tabCycles) {
                        this.cycle(Screen.m_96638_() ? -1 : 1);
                    }
                    this.useSuggestion();
                    yield true;
                }
                case 256 -> {
                    SuggestedEditBox.this.hideSuggestions();
                    yield true;
                }
                case 257 -> {
                    this.useSuggestion();
                    SuggestedEditBox.this.hideSuggestions();
                    yield true;
                }
                default -> false;
            };
        }

        public void cycle(int change) {
            this.select(this.current + change);
            int i = this.offset;
            int j = this.offset + this.suggestionLineLimit - 1;
            if (this.current < i) {
                this.offset = Mth.m_14045_((int)this.current, (int)0, (int)Math.max(this.suggestionList.size() - this.suggestionLineLimit, 0));
            } else if (this.current > j) {
                this.offset = Mth.m_14045_((int)(this.current + this.lineStartOffset - this.suggestionLineLimit), (int)0, (int)Math.max(this.suggestionList.size() - this.suggestionLineLimit, 0));
            }
        }

        public void select(int index) {
            if (this.suggestionList.isEmpty()) {
                return;
            }
            this.current = index;
            if (this.current < 0) {
                this.current += this.suggestionList.size();
            }
            if (this.current >= this.suggestionList.size()) {
                this.current -= this.suggestionList.size();
            }
            Suggestion suggestion = this.suggestionList.get(this.current);
            if (this.lastNarratedEntry != this.current) {
                Minecraft.m_91087_().m_240477_().m_168785_(this.getNarrationMessage());
            }
        }

        public void useSuggestion() {
            Suggestion suggestion = this.suggestionList.get(this.current);
            this.keepSuggestions = true;
            SuggestedEditBox.this.m_94144_(suggestion.apply(this.originalContents));
            int i = suggestion.getRange().getStart() + suggestion.getText().length();
            SuggestedEditBox.this.m_94196_(i);
            SuggestedEditBox.this.m_94208_(i);
            this.select(this.current);
            this.keepSuggestions = false;
            this.tabCycles = true;
        }

        Component getNarrationMessage() {
            this.lastNarratedEntry = this.current;
            Suggestion suggestion = this.suggestionList.get(this.current);
            Message message = suggestion.getTooltip();
            if (message != null) {
                return Component.m_237110_((String)"narration.suggestion.tooltip", (Object[])new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText(), message});
            }
            return Component.m_237110_((String)"narration.suggestion", (Object[])new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText()});
        }
    }
}

