/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListWidget<E extends Entry>
extends AbstractWidget
implements ContainerEventHandler {
    private final int itemHeight;
    private final List<E> entries = new ArrayList();
    private final Minecraft mc = Minecraft.m_91087_();
    private final Font font;
    @Nullable
    private E selected;
    private boolean renderSelection;
    private double scrollAmount;
    private boolean scrolling;
    private boolean dragging;

    public ListWidget(int x, int y, int width, int height, int itemHeight, Component message) {
        super(x, y, width, height, message);
        this.font = this.mc.f_91062_;
        this.renderSelection = false;
        this.itemHeight = itemHeight;
    }

    public List<E> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public void addEntry(E entry) {
        this.entries.add(entry);
    }

    public void clear() {
        this.entries.clear();
        this.selected = null;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        this.selected = selected;
    }

    @Nullable
    public E getEntryAtPosition(double mouseX, double mouseY) {
        int index = Mth.m_14045_((int)Mth.m_14107_((double)(mouseY - (double)this.m_252907_() + this.getScrollAmount() - 4.0)), (int)0, (int)this.getMaxPosition()) / this.itemHeight;
        if (mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.f_93618_) && index >= 0 && index < this.entries.size()) {
            return (E)((Entry)this.entries.get(index));
        }
        return null;
    }

    @NotNull
    public List<E> m_6702_() {
        return this.getEntries();
    }

    public int getMaxPosition() {
        return this.entries.size() * this.itemHeight;
    }

    private void scroll(int scroll) {
        this.setScrollAmount(this.getScrollAmount() + (double)scroll);
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double scroll) {
        this.scrollAmount = Mth.m_14008_((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.f_93619_ + 4);
    }

    public void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.m_252754_() + this.f_93618_ - 6;
    }

    public void ensureVisible(E entry) {
        int k;
        int entryTop = this.m_252907_() + 4 - (int)this.getScrollAmount() + this.entries.indexOf(entry) * this.itemHeight;
        int j = entryTop - this.m_252907_() - 4 - this.itemHeight;
        if (j < 0) {
            this.scroll(j);
        }
        if ((k = this.m_252907_() + this.f_93619_ - entryTop - this.itemHeight * 2) < 0) {
            this.scroll(-k);
        }
    }

    protected void setRenderSelection() {
        this.renderSelection = true;
    }

    protected void renderList(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        for (int index = 0; index < this.entries.size(); ++index) {
            int entryTop = this.m_252907_() + 4 - (int)this.getScrollAmount() + index * this.itemHeight;
            int entryBottom = entryTop + this.itemHeight;
            if (entryBottom < this.m_252907_() || entryTop > this.m_252907_() + this.f_93619_) continue;
            this.renderItem(graphics, mouseX, mouseY, partialTick, index, this.m_252754_(), entryTop, this.f_93618_, this.itemHeight - 4);
        }
    }

    protected void renderItem(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int index, int left, int top, int width, int height) {
        Entry entry = (Entry)this.entries.get(index);
        entry.renderBackground(graphics, index, left, top, width, height, mouseX, mouseY, partialTick);
        if (this.renderSelection && this.selected == entry) {
            this.renderSelection(graphics, top, width - 8, height, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0), FastColor.ARGB32.m_13660_((int)255, (int)198, (int)198, (int)198));
        }
        entry.render(graphics, index, left, top, width, height, mouseX, mouseY, partialTick);
        for (Object children : entry.m_6702_()) {
            if (!(children instanceof Renderable)) continue;
            Renderable renderable = (Renderable)children;
            renderable.m_88315_(graphics, mouseX, mouseY, partialTick);
        }
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int barLeft = this.getScrollbarPosition();
        int barRight = barLeft + 6;
        graphics.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_);
        this.renderList(graphics, mouseX, mouseY, partialTick);
        graphics.m_280618_();
        if (this.getMaxScroll() > 0) {
            int n = (int)((float)(this.f_93619_ * this.f_93619_) / (float)this.getMaxPosition());
            n = Mth.m_14045_((int)n, (int)32, (int)(this.f_93619_ - 8));
            int o = (int)this.getScrollAmount() * (this.f_93619_ - n) / this.getMaxScroll() + this.m_252907_();
            if (o < this.m_252907_()) {
                o = this.m_252907_();
            }
            graphics.m_280509_(barLeft, this.m_252907_(), barRight, this.m_252907_() + this.f_93619_, -16777216);
            graphics.m_280509_(barLeft, o, barRight, o + n, -8355712);
            graphics.m_280509_(barLeft, o, barRight - 1, o + n - 1, -4144960);
        }
        RenderSystem.disableBlend();
    }

    protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        guiGraphics.m_280509_(this.m_252754_(), top - 2, this.m_252754_() + width, top + height + 2, outerColor);
        guiGraphics.m_280509_(this.m_252754_() + 1, top - 1, this.m_252754_() + width - 1, top + height + 1, innerColor);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.m_6375_(mouseX, mouseY, button)) {
            GuiEventListener focused = this.m_7222_();
            if (focused != entry && focused instanceof ContainerEventHandler) {
                ContainerEventHandler container = (ContainerEventHandler)focused;
                container.m_7522_(null);
            }
            this.m_7522_((GuiEventListener)entry);
            this.m_7897_(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.m_7222_() != null) {
            this.m_7222_().m_6348_(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        if (this.m_7222_() != null) {
            this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        if (button != 0 || !this.scrolling) {
            return false;
        }
        if (mouseY < (double)this.m_252907_()) {
            this.setScrollAmount(0.0);
        } else if (mouseY > (double)(this.m_252907_() + this.f_93619_)) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            double d = Math.max(1, this.getMaxScroll());
            int i = this.f_93619_;
            int j = Mth.m_14045_((int)((int)((float)(i * i) / (float)this.getMaxPosition())), (int)32, (int)(i - 8));
            double e = Math.max(1.0, d / (double)(i - j));
            this.setScrollAmount(this.getScrollAmount() + dragY * e);
        }
        return true;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.setScrollAmount(this.getScrollAmount() - delta * (double)this.itemHeight / 2.0);
        return true;
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent event) {
        if (this.entries.isEmpty()) {
            return null;
        }
        if (event instanceof FocusNavigationEvent.ArrowNavigation) {
            ComponentPath componentPath;
            FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
            E entry = this.selected;
            if (arrowNavigation.f_263812_().m_264093_() == ScreenAxis.HORIZONTAL && entry != null) {
                return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)((Entry)entry).m_264064_(event));
            }
            int i = -1;
            ScreenDirection screenDirection = arrowNavigation.f_263812_();
            if (entry != null) {
                i = entry.m_6702_().indexOf(((Entry)entry).m_7222_());
            }
            if (i == -1) {
                switch (screenDirection) {
                    case LEFT: {
                        i = Integer.MAX_VALUE;
                        screenDirection = ScreenDirection.DOWN;
                        break;
                    }
                    case RIGHT: {
                        i = 0;
                        screenDirection = ScreenDirection.DOWN;
                        break;
                    }
                    default: {
                        i = 0;
                    }
                }
            }
            Object entry2 = entry;
            do {
                if ((entry2 = this.nextEntry(screenDirection, arg -> !arg.m_6702_().isEmpty(), entry2)) != null) continue;
                return null;
            } while ((componentPath = ((Entry)entry2).focusPathAtIndex((FocusNavigationEvent)arrowNavigation, i)) == null);
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)componentPath);
        }
        return super.m_264064_(event);
    }

    @Nullable
    protected E nextEntry(ScreenDirection direction, Predicate<E> predicate, @Nullable E selected) {
        int b0;
        switch (direction) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LEFT: 
            case RIGHT: {
                int n = 0;
                break;
            }
            case UP: {
                int n = -1;
                break;
            }
            case DOWN: {
                int n = b0 = 1;
            }
        }
        if (!this.m_6702_().isEmpty() && b0 != 0) {
            int j = selected == null ? (b0 > 0 ? 0 : this.m_6702_().size() - 1) : this.m_6702_().indexOf(selected) + b0;
            for (int k = j; k >= 0 && k < this.entries.size(); k += b0) {
                Entry e = (Entry)this.m_6702_().get(k);
                if (!predicate.test(e)) continue;
                return (E)e;
            }
        }
        return null;
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        int i = this.entries.indexOf(focused);
        if (i >= 0) {
            Entry entry = (Entry)this.entries.get(i);
            this.setSelected(entry);
            if (this.mc.m_264529_().m_264505_()) {
                this.ensureVisible(entry);
            }
            entry.m_93692_(true);
        } else {
            this.setSelected(null);
        }
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.selected;
    }

    public void m_7897_(boolean isDragging) {
        this.dragging = isDragging;
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public static abstract class Entry
    implements ContainerEventHandler {
        @Nullable
        private GuiEventListener focused;
        private boolean dragging;

        protected void renderBackground(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, float partialTicks) {
        }

        protected abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9);

        public boolean m_7282_() {
            return this.dragging;
        }

        public void m_7897_(boolean isDragging) {
            this.dragging = isDragging;
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.focused;
        }

        public void m_7522_(@Nullable GuiEventListener focused) {
            if (this.focused != null) {
                this.focused.m_93692_(false);
            }
            if (focused != null) {
                focused.m_93692_(true);
            }
            this.focused = focused;
        }

        @Nullable
        public ComponentPath focusPathAtIndex(FocusNavigationEvent event, int index) {
            if (this.m_6702_().isEmpty()) {
                return null;
            }
            ComponentPath componentPath = ((GuiEventListener)this.m_6702_().get(Math.min(index, this.m_6702_().size() - 1))).m_264064_(event);
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)componentPath);
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            if (event instanceof FocusNavigationEvent.ArrowNavigation) {
                int i;
                FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
                int n = i = arrowNavigation.f_263812_() == ScreenDirection.RIGHT ? 1 : 0;
                if (i == 0) {
                    return null;
                }
                for (int k = Mth.m_14045_((int)(i + this.m_6702_().indexOf(this.m_7222_())), (int)0, (int)(this.m_6702_().size() - 1)); k >= 0 && k < this.m_6702_().size(); k += i) {
                    GuiEventListener guiEventListener = (GuiEventListener)this.m_6702_().get(k);
                    ComponentPath componentPath = guiEventListener.m_264064_(event);
                    if (componentPath == null) continue;
                    return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)componentPath);
                }
            }
            return super.m_264064_(event);
        }
    }
}

