/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class DoubleSlider
extends AbstractSliderButton {
    private final Component baseMessage;
    private final double min;
    private final double max;
    private final boolean onlyValue;
    private final Consumer<Double> responder;

    public static Builder builder() {
        return new Builder();
    }

    private DoubleSlider(int x, int y, int width, int height, Component message, double value, double min, double max, boolean onlyValue, Consumer<Double> responder) {
        super(x, y, width, height, (Component)(onlyValue ? Component.m_237113_((String)String.format("%.2f", Mth.m_144914_((double)value, (double)0.0, (double)1.0, (double)min, (double)max))) : Component.m_237119_().m_7220_(message).m_130946_(": " + (int)Mth.m_144914_((double)value, (double)0.0, (double)1.0, (double)min, (double)max))), value);
        this.baseMessage = message;
        this.min = min;
        this.max = max;
        this.onlyValue = onlyValue;
        this.responder = responder;
    }

    public double doubleValue() {
        return Mth.m_144914_((double)this.f_93577_, (double)0.0, (double)1.0, (double)this.min, (double)this.max);
    }

    public void setValue(double value) {
        this.f_93577_ = Mth.m_144914_((double)value, (double)this.min, (double)this.max, (double)0.0, (double)1.0);
        this.m_5697_();
        this.m_5695_();
    }

    protected void m_5695_() {
        if (this.onlyValue) {
            this.m_93666_((Component)Component.m_237113_((String)String.format("%.2f", this.doubleValue())));
        } else {
            this.m_93666_((Component)Component.m_237119_().m_7220_(this.baseMessage).m_130946_(String.format(": %.2f", this.doubleValue())));
        }
    }

    protected void m_5697_() {
        this.responder.accept(this.doubleValue());
    }

    public static class Builder {
        private double defaultValue = 0.0;
        private double min = 0.0;
        private double max = 1000.0;
        private boolean onlyValue = false;
        private Consumer<Double> responder = value -> {};

        public Builder bounds(double min, double max) {
            this.min = min;
            this.max = max;
            this.defaultValue = Mth.m_14008_((double)this.defaultValue, (double)this.min, (double)this.max);
            return this;
        }

        public Builder defaultValue(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder displayOnlyValue() {
            this.onlyValue = true;
            return this;
        }

        public Builder setResponder(Consumer<Double> responder) {
            this.responder = responder;
            return this;
        }

        public DoubleSlider create(int x, int y, int width, int height, Component message) {
            return new DoubleSlider(x, y, width, height, message, Mth.m_144914_((double)Mth.m_14008_((double)this.defaultValue, (double)this.min, (double)this.max), (double)this.min, (double)this.max, (double)0.0, (double)1.0), this.min, this.max, this.onlyValue, this.responder);
        }
    }
}

