/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.popup;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;

public abstract class PopupScreen
extends BaseScreen {
    public final BaseScreen parent;
    private boolean dragging;
    private double dragX;
    private double dragY;

    public PopupScreen(BaseScreen parent, int xSize, int ySize) {
        super((Component)Component.m_237113_((String)"Popup"), xSize, ySize);
        this.parent = parent;
    }

    public void closed() {
    }

    public void move(int movedX, int movedY) {
        this.x += movedX;
        this.y += movedY;
        this.m_6702_().forEach(c -> {
            if (c instanceof LayoutElement) {
                LayoutElement widget = (LayoutElement)c;
                widget.m_264152_(widget.m_252754_() + movedX, widget.m_252907_() + movedY);
            }
        });
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.x = (this.f_96543_ - this.xSize) / 2;
        this.y = (this.f_96544_ - this.ySize) / 2;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if ((int)Math.abs(this.dragX) >= 1 || (int)Math.abs(this.dragY) >= 1) {
            int changedX = (int)this.dragX;
            int changedY = (int)this.dragY;
            this.move(changedX, changedY);
            this.dragX -= (double)changedX;
            this.dragY -= (double)changedY;
        }
        boolean parentHasTooltip = this.parent.f_262730_ != null;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (!parentHasTooltip && this.parent.f_262730_ != null) {
            if (this.f_262730_ == null) {
                this.f_262730_ = this.parent.f_262730_;
            }
            this.parent.f_262730_ = null;
        }
    }

    public void m_280273_(GuiGraphics graphics) {
        PopupScreen.blankBackground(graphics, this.x, this.y, this.xSize, this.ySize);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.m_5953_(mouseX, mouseY) && mouseY < (double)(this.y + 20)) {
            this.dragging = true;
            return true;
        }
        this.m_7897_(false);
        return false;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            this.dragX += deltaX;
            this.dragY += deltaY;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean m_5953_(double mouseX, double mouseY) {
        return this.parent.getPopupUnderMouse(mouseX, mouseY) == this;
    }
}

