/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.popup;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class ConfirmPopup
extends PopupScreen {
    public static final Component CONFIRM = Component.m_237115_((String)"custommachinery.gui.popup.confirm").m_130940_(ChatFormatting.GREEN);
    public static final Component CANCEL = Component.m_237115_((String)"custommachinery.gui.popup.cancel").m_130940_(ChatFormatting.RED);
    private final Runnable onConfirm;
    private final List<Component> text = new ArrayList<Component>();
    private Component title;
    @Nullable
    private Runnable onCancel;

    public ConfirmPopup(BaseScreen parent, int xSize, int ySize, Runnable onConfirm) {
        super(parent, xSize, ySize);
        this.onConfirm = onConfirm;
        this.onCancel = null;
    }

    public ConfirmPopup cancelCallback(Runnable callback) {
        this.onCancel = callback;
        return this;
    }

    public ConfirmPopup title(Component title) {
        this.title = title;
        return this;
    }

    public ConfirmPopup text(Component ... components) {
        this.text.addAll(Arrays.asList(components));
        return this;
    }

    public void confirm() {
        this.onConfirm.run();
        this.parent.closePopup(this);
    }

    public void cancel() {
        if (this.onCancel != null) {
            this.onCancel.run();
        }
        this.parent.closePopup(this);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        GridLayout layout = new GridLayout(this.x, this.y);
        GridLayout.RowHelper row = layout.m_264606_(2);
        row.m_264502_().m_264311_(5);
        if (this.title != null) {
            row.m_264108_((LayoutElement)new StringWidget(this.xSize, 10, this.title, Minecraft.m_91087_().f_91062_).m_267729_(), 2);
        }
        if (!this.text.isEmpty()) {
            MutableComponent text = Component.m_237119_();
            for (Component component : this.text) {
                text.m_130946_("\n").m_7220_(component);
            }
            MultiLineTextWidget textWidget = new MultiLineTextWidget((Component)text, Minecraft.m_91087_().f_91062_).m_269484_(true).m_269098_(this.xSize - 10);
            this.ySize = textWidget.m_93694_() + 50;
            row.m_264276_((LayoutElement)textWidget, 2, row.m_264551_().m_264356_());
        }
        row.m_264206_((LayoutElement)Button.m_253074_((Component)CONFIRM, b -> this.confirm()).m_252987_(0, 0, 50, 20).m_253136_(), row.m_264551_().m_264356_());
        row.m_264206_((LayoutElement)Button.m_253074_((Component)CANCEL, b -> this.cancel()).m_252987_(0, 0, 50, 20).m_253136_(), row.m_264551_().m_264356_());
        layout.m_264036_();
        layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }
}

