/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui.builder;

import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.GroupWidget;
import fr.frinn.custommachinery.client.screen.widget.IntegerSlider;
import fr.frinn.custommachinery.client.screen.widget.SuggestedEditBox;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Color;
import fr.frinn.custommachinery.common.util.GhostItem;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class SlotGuiElementBuilder
implements IGuiElementBuilder<SlotGuiElement> {
    @Override
    public GuiElementType<SlotGuiElement> type() {
        return (GuiElementType)Registration.SLOT_GUI_ELEMENT.get();
    }

    @Override
    public SlotGuiElement make(AbstractGuiElement.Properties properties, @Nullable SlotGuiElement from) {
        if (from != null) {
            return new SlotGuiElement(properties, from.getGhost());
        }
        return new SlotGuiElement(properties, GhostItem.EMPTY);
    }

    @Override
    public PopupScreen makeConfigPopup(MachineEditScreen parent, MutableProperties properties, SlotGuiElement from, Consumer<SlotGuiElement> onFinish) {
        return new SlotGuiElementBuilderPopup((BaseScreen)parent, properties, from, onFinish);
    }

    public static class SlotGuiElementBuilderPopup
    extends GuiElementBuilderPopup<SlotGuiElement> {
        private GhostItemWidget ghostItem;

        public SlotGuiElementBuilderPopup(BaseScreen parent, MutableProperties properties, @Nullable SlotGuiElement from, Consumer<SlotGuiElement> onFinish) {
            super(parent, properties, from, onFinish);
        }

        @Override
        public SlotGuiElement makeElement() {
            return new SlotGuiElement(this.properties.build(), this.ghostItem.getGhost());
        }

        @Override
        public Component canCreate() {
            if (this.properties.getId().isEmpty()) {
                return Component.m_237115_((String)"custommachinery.gui.creation.gui.id.missing");
            }
            return super.canCreate();
        }

        @Override
        public void addWidgets(GridLayout.RowHelper row) {
            this.addTexture(row, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.texture"), this.properties::setTexture, this.baseElement == null ? SlotGuiElement.BASE_TEXTURE : ((SlotGuiElement)this.baseElement).getTexture());
            this.addId(row);
            this.addPriority(row);
            row.m_264139_((LayoutElement)new StringWidget((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.slot.ghost"), this.f_96547_));
            this.ghostItem = (GhostItemWidget)row.m_264139_((LayoutElement)new GhostItemWidget());
            if (this.baseElement != null && ((SlotGuiElement)this.baseElement).getGhost() != GhostItem.EMPTY) {
                this.ghostItem.setGhost(((SlotGuiElement)this.baseElement).getGhost());
            }
        }
    }

    public static class GhostItemWidget
    extends GroupWidget {
        private static final ResourceLocation WIDGETS = new ResourceLocation("custommachinery", "textures/gui/creation/style_widget.png");
        private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("custommachinery", "textures/gui/base_slot.png");
        private final SuggestedEditBox items;
        private final Checkbox alwaysVisible;
        private final IntegerSlider transparency;
        private Color color = Color.WHITE;

        public GhostItemWidget() {
            super(0, 0, 100, 60, (Component)Component.m_237119_());
            this.items = this.addWidget(new SuggestedEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 100, 20, (Component)Component.m_237119_(), 5));
            this.items.addSuggestions(BuiltInRegistries.f_257033_.m_6566_().stream().map(ResourceLocation::toString).toList());
            this.alwaysVisible = this.addWidget(new Checkbox(80, 22, 20, 20, (Component)Component.m_237119_(), false));
            this.alwaysVisible.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.slot.ghost.alwaysVisible")));
            this.transparency = this.addWidget(IntegerSlider.builder().displayOnlyValue().bounds(0, 100).defaultValue(100).setResponder(value -> {
                this.color = Color.fromColors((int)((float)value.intValue() * 2.55f), this.color.getRed(), this.color.getGreen(), this.color.getBlue());
            }).create(0, 43, 100, 20, (Component)Component.m_237110_((String)"custommachinery.gui.creation.gui.slot.ghost.transparency", (Object[])new Object[]{100})));
            for (int i = 0; i < 16; ++i) {
                ChatFormatting format = ChatFormatting.m_126647_((int)i);
                if (format == null) continue;
                ImageButton button = new ImageButton(i % 8 * 10 - 1, (i < 8 ? 0 : 10) + 22, 10, 10, i * 10, 0, WIDGETS, b -> {
                    this.color = format.m_126665_() != null ? Color.fromARGB(this.color.getAlpha() << 24 | format.m_126665_()) : Color.WHITE;
                });
                this.addWidget(button);
                button.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)format.m_126666_()).m_130940_(format)));
            }
        }

        public void setGhost(GhostItem ghost) {
            this.items.m_94144_(BuiltInRegistries.f_257033_.m_7981_((Object)ghost.items().get(0).getAll().get(0)).toString());
            this.items.hideSuggestions();
            if (ghost.alwaysRender() != this.alwaysVisible.m_93840_()) {
                this.alwaysVisible.m_5691_();
            }
            this.transparency.setValue((int)((float)ghost.color().getAlpha() / 255.0f * 100.0f));
            this.color = ghost.color();
        }

        public GhostItem getGhost() {
            try {
                return new GhostItem(Collections.singletonList(new ItemIngredient((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(this.items.m_94155_())))), this.color, this.alwaysVisible.m_93840_());
            }
            catch (NullPointerException | ResourceLocationException e) {
                return GhostItem.EMPTY;
            }
        }

        @Override
        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.m_280411_(SLOT_TEXTURE, this.m_252754_() - 20, this.m_252907_(), 18, 18, 0.0f, 0.0f, 18, 18, 18, 18);
            try {
                graphics.m_280246_((float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, (float)this.color.getAlpha() / 255.0f);
                graphics.m_280480_(((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(this.items.m_94155_()))).m_7968_(), this.m_252754_() - 19, this.m_252907_() + 1);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            catch (NullPointerException | ResourceLocationException ignored) {
                System.out.println("NULL");
            }
            super.m_87963_(graphics, mouseX, mouseY, partialTick);
        }
    }
}

