/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui.builder;

import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.common.guielement.DumpGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DumpGuiElementBuilder
implements IGuiElementBuilder<DumpGuiElement> {
    @Override
    public GuiElementType<DumpGuiElement> type() {
        return (GuiElementType)Registration.DUMP_GUI_ELEMENT.get();
    }

    @Override
    public DumpGuiElement make(AbstractGuiElement.Properties properties, @Nullable DumpGuiElement from) {
        if (from != null) {
            return new DumpGuiElement(properties, from.getComponents(), from.getTanks());
        }
        return new DumpGuiElement(properties, Collections.singletonList((MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get()), Collections.emptyList());
    }

    @Override
    public PopupScreen makeConfigPopup(MachineEditScreen parent, MutableProperties properties, @Nullable DumpGuiElement from, Consumer<DumpGuiElement> onFinish) {
        return new DumpGuiElementBuilderPopup((BaseScreen)parent, properties, from, onFinish);
    }

    public static class DumpGuiElementBuilderPopup
    extends GuiElementBuilderPopup<DumpGuiElement> {
        private EditBox components;
        private EditBox tanks;

        public DumpGuiElementBuilderPopup(BaseScreen parent, MutableProperties properties, @Nullable DumpGuiElement from, Consumer<DumpGuiElement> onFinish) {
            super(parent, properties, from, onFinish);
        }

        @Override
        public DumpGuiElement makeElement() {
            List<MachineComponentType<?>> components = Arrays.stream(this.components.m_94155_().split(",")).filter(s -> ResourceLocation.m_135820_((String)s) != null && Registration.MACHINE_COMPONENT_TYPE_REGISTRY.contains(ResourceLocation.m_135820_((String)s))).map(s -> (MachineComponentType)Registration.MACHINE_COMPONENT_TYPE_REGISTRY.get(ResourceLocation.m_135820_((String)s))).collect(Collectors.toList());
            List<String> tanks = Arrays.stream(this.tanks.m_94155_().split(",")).filter(s -> !s.isEmpty()).toList();
            return new DumpGuiElement(this.properties.build(), components, tanks);
        }

        @Override
        public void addWidgets(GridLayout.RowHelper row) {
            this.addTexture(row, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.texture"), this.properties::setTexture, DumpGuiElement.BASE_TEXTURE);
            this.addTexture(row, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.texture_hovered"), this.properties::setTextureHovered, DumpGuiElement.BASE_TEXTURE_HOVERED);
            this.addPriority(row);
            row.m_264139_((LayoutElement)new StringWidget((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.dump.components"), this.f_96547_));
            this.components = (EditBox)row.m_264139_((LayoutElement)new EditBox(this.f_96547_, 0, 0, 100, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.dump.components")));
            this.components.m_94144_(this.baseElement == null ? ((GuiElementType)Registration.FLUID_GUI_ELEMENT.get()).getId().toString() : this.listToString(((DumpGuiElement)this.baseElement).getComponents().stream().map(type -> type.getId().toString()).toList()));
            this.components.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.dump.components.tooltip")));
            row.m_264139_((LayoutElement)new StringWidget((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.dump.tanks"), this.f_96547_));
            this.tanks = (EditBox)row.m_264139_((LayoutElement)new EditBox(this.f_96547_, 0, 0, 100, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.dump.tanks")));
            this.tanks.m_94144_(this.baseElement == null ? "" : this.listToString(((DumpGuiElement)this.baseElement).getTanks()));
            this.tanks.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.dump.tanks.tooltip")));
        }

        private <T> String listToString(List<T> list) {
            StringBuilder builder = new StringBuilder();
            Iterator<T> iterator = list.iterator();
            while (iterator.hasNext()) {
                T next = iterator.next();
                builder.append(next.toString());
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            return builder.toString();
        }
    }
}

