/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderRegistry;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.ListWidget;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;

public class GuiElementCreationPopup
extends PopupScreen {
    public static final Component CONFIRM = Component.m_237115_((String)"custommachinery.gui.popup.confirm").m_130940_(ChatFormatting.GREEN);
    public static final Component CANCEL = Component.m_237115_((String)"custommachinery.gui.popup.cancel").m_130940_(ChatFormatting.RED);
    private final Consumer<IGuiElement> onChange;
    private GuiElementCreationListWidget list;

    public GuiElementCreationPopup(MachineEditScreen parent, Consumer<IGuiElement> onChange) {
        super(parent, 116, 144);
        this.onChange = onChange;
    }

    private void confirm() {
        BaseScreen baseScreen;
        GuiElementCreationListWidget.GuiElementCreationListEntry entry = (GuiElementCreationListWidget.GuiElementCreationListEntry)this.list.getSelected();
        if (entry != null && (baseScreen = this.parent) instanceof MachineEditScreen) {
            MachineEditScreen editScreen = (MachineEditScreen)baseScreen;
            PopupScreen componentCreationPopup = entry.builder.makeConfigPopup(editScreen, new MutableProperties(), null, element -> {
                editScreen.getBuilder().getGuiElements().add((IGuiElement)element);
                editScreen.setChanged();
                this.onChange.accept((IGuiElement)element);
            });
            editScreen.closePopup(this);
            editScreen.openPopup(componentCreationPopup);
        }
    }

    private void cancel() {
        this.parent.closePopup(this);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        MutableComponent title = Component.m_237115_((String)"custommachinery.gui.creation.components.create.title");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new StringWidget(this.x, this.y + 5, this.xSize, 9, (Component)title, Minecraft.m_91087_().f_91062_));
        this.list = (GuiElementCreationListWidget)this.m_142416_((GuiEventListener)new GuiElementCreationListWidget(this.x + 3, this.y + 15, this.xSize - 10, this.ySize - 50));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CONFIRM, b -> this.confirm()).m_252987_(this.x + 5, this.y + this.ySize - 30, 50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CANCEL, b -> this.cancel()).m_252987_(this.x + this.xSize - 55, this.y + this.ySize - 30, 50, 20).m_253136_());
    }

    protected static class GuiElementCreationListWidget
    extends ListWidget<GuiElementCreationListEntry> {
        public GuiElementCreationListWidget(int x, int y, int width, int height) {
            super(x, y, width, height, 20, (Component)Component.m_237119_());
            this.setRenderSelection();
            for (GuiElementType type : Registration.GUI_ELEMENT_TYPE_REGISTRY.entrySet().stream().sorted(Comparator.comparing(entry -> ((ResourceKey)entry.getKey()).m_135782_())).map(Map.Entry::getValue).toList()) {
                IGuiElementBuilder builder = GuiElementBuilderRegistry.getBuilder(type);
                if (builder == null) continue;
                this.addEntry(new GuiElementCreationListEntry(builder));
            }
            this.setSelected(this.getEntries().isEmpty() ? null : (GuiElementCreationListEntry)this.getEntries().get(0));
        }

        protected static class GuiElementCreationListEntry
        extends ListWidget.Entry {
            private final IGuiElementBuilder<?> builder;

            private GuiElementCreationListEntry(IGuiElementBuilder<?> builder) {
                this.builder = builder;
            }

            @Override
            public void render(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
                graphics.m_280614_(Minecraft.m_91087_().f_91062_, this.builder.type().getTranslatedName(), x + 5, y + 5, 0, false);
            }

            public List<? extends GuiEventListener> m_6702_() {
                return Collections.emptyList();
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return true;
            }
        }
    }
}

