/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.SuggestedEditBox;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class GuiElementBuilderPopup<T extends IGuiElement>
extends PopupScreen {
    public final MutableProperties properties;
    @Nullable
    public final T baseElement;
    private final Consumer<T> onFinish;
    private Button confirm;

    public GuiElementBuilderPopup(BaseScreen parent, MutableProperties properties, @Nullable T from, Consumer<T> onFinish) {
        super(parent, 256, 196);
        this.properties = properties;
        this.baseElement = from;
        this.onFinish = onFinish;
    }

    public abstract T makeElement();

    public abstract void addWidgets(GridLayout.RowHelper var1);

    public Component canCreate() {
        return Component.m_237119_();
    }

    private void save() {
        this.onFinish.accept(this.makeElement());
        this.parent.closePopup(this);
    }

    public void addId(GridLayout.RowHelper row) {
        row.m_264139_((LayoutElement)new StringWidget((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.id"), this.f_96547_));
        SuggestedEditBox id = (SuggestedEditBox)row.m_264139_((LayoutElement)new SuggestedEditBox(this.f_96547_, 0, 0, 100, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.id"), 5));
        id.m_94151_(this.properties::setId);
        id.m_94144_(this.properties.getId());
        BaseScreen baseScreen = this.parent;
        if (baseScreen instanceof MachineEditScreen) {
            MachineEditScreen editScreen = (MachineEditScreen)baseScreen;
            id.addSuggestions(editScreen.getBuilder().getComponents().stream().map(IMachineComponentTemplate::getId).filter(s -> !s.isEmpty()).toList());
        }
    }

    public void addPriority(GridLayout.RowHelper row) {
        row.m_264139_((LayoutElement)new StringWidget((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.priority"), this.f_96547_));
        EditBox priority = (EditBox)row.m_264139_((LayoutElement)new EditBox(this.f_96547_, 0, 0, 100, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.priority")));
        priority.m_94151_(value -> this.properties.setPriority(Integer.parseInt(value)));
        priority.m_94153_(value -> {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        });
        priority.m_94144_("" + this.properties.getPriority());
    }

    public void addTexture(GridLayout.RowHelper row, Component title, Consumer<ResourceLocation> responder, @Nullable ResourceLocation baseTexture) {
        row.m_264139_((LayoutElement)new StringWidget(title, this.f_96547_));
        SuggestedEditBox texture = (SuggestedEditBox)row.m_264139_((LayoutElement)new SuggestedEditBox(this.f_96547_, 0, 0, 100, 20, title, 5));
        texture.m_94199_(Integer.MAX_VALUE);
        texture.m_94151_(s -> responder.accept(s.isEmpty() ? null : ResourceLocation.m_135820_((String)s)));
        texture.m_94144_(baseTexture == null ? "" : baseTexture.toString());
        texture.hideSuggestions();
        texture.addSuggestions(Minecraft.m_91087_().m_91098_().m_214159_("textures", id -> true).keySet().stream().map(ResourceLocation::toString).toList());
        texture.m_94153_(s -> ResourceLocation.m_135820_((String)s) != null);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        GridLayout layout = new GridLayout(this.x, this.y);
        layout.m_264211_().m_264311_(5).m_264215_(5);
        GridLayout.RowHelper row = layout.m_264606_(2);
        LayoutSettings center = row.m_264551_().m_264356_();
        Objects.requireNonNull(this.f_96547_);
        row.m_264276_((LayoutElement)new StringWidget(this.xSize, 9, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.edit"), this.f_96547_), 2, center);
        this.addWidgets(row);
        this.confirm = (Button)row.m_264206_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"custommachinery.gui.popup.confirm").m_130940_(ChatFormatting.GREEN), button -> this.save()).m_253046_(50, 20).m_253136_(), center);
        row.m_264206_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"custommachinery.gui.popup.cancel").m_130940_(ChatFormatting.RED), button -> this.parent.closePopup(this)).m_253046_(50, 20).m_253136_(), center);
        layout.m_264036_();
        this.ySize = layout.m_93694_() + 10;
        layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        Component canCreate = this.canCreate();
        if (canCreate.getString().isEmpty()) {
            this.confirm.f_93623_ = true;
        } else {
            this.confirm.f_93623_ = false;
            if (this.confirm.m_274382_()) {
                graphics.m_280557_(this.f_96547_, canCreate, mouseX, mouseY);
            }
        }
    }
}

