/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.api.machine.ICustomMachine;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderRegistry;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.ConfirmPopup;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.guielement.GuiElementWidgetSupplierRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class GuiEditorWidget
extends AbstractWidget
implements ContainerEventHandler {
    private final MachineEditScreen parent;
    private final IMachineScreen dummyScreen = new DummyScreen();
    private final List<IGuiElement> elements = new ArrayList<IGuiElement>();
    private final List<WidgetEditorWidget<?>> widgets = new ArrayList();
    private final Button config;
    private final Button priorityUp;
    private final Button priorityDown;
    private final Button delete;
    private boolean dragging;
    private GuiEventListener focused;

    public GuiEditorWidget(MachineEditScreen parent, int x, int y, int width, int height, List<IGuiElement> baseElements) {
        super(x, y, width, height, (Component)Component.m_237119_());
        this.parent = parent;
        baseElements.stream().sorted(Comparators.GUI_ELEMENTS_COMPARATOR.reversed()).forEach(this::addElement);
        this.config = Button.m_253074_((Component)Component.m_237119_(), button -> {
            GuiEventListener patt2664$temp = this.m_7222_();
            if (patt2664$temp instanceof WidgetEditorWidget) {
                WidgetEditorWidget widget = (WidgetEditorWidget)patt2664$temp;
                this.config(widget);
            }
        }).m_253046_(5, 5).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.config"))).m_253136_();
        this.priorityUp = Button.m_253074_((Component)Component.m_237119_(), button -> this.changePriority(1)).m_253046_(5, 5).m_253136_();
        this.priorityDown = Button.m_253074_((Component)Component.m_237119_(), button -> this.changePriority(-1)).m_253046_(5, 5).m_253136_();
        this.delete = Button.m_253074_((Component)Component.m_237119_(), button -> this.delete()).m_253046_(5, 5).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.delete"))).m_253136_();
    }

    public void addElement(IGuiElement element) {
        if (!GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType()) || !GuiElementBuilderRegistry.hasBuilder(element.getType())) {
            return;
        }
        this.elements.add(element);
        this.widgets.add(this.getWidget(element));
    }

    public void addCreatedElement(IGuiElement element) {
        if (!GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType()) || !GuiElementBuilderRegistry.hasBuilder(element.getType())) {
            return;
        }
        this.elements.add(element);
        WidgetEditorWidget<IGuiElement> widget = this.getWidget(element);
        widget.m_264152_(this.m_252754_() + (this.m_5711_() + widget.m_5711_()) / 2, this.m_252907_() + (this.m_93694_() + widget.m_93694_()) / 2);
        this.widgets.add(widget);
        this.m_7522_((GuiEventListener)widget);
    }

    public void hideButtons() {
        this.config.f_93624_ = false;
        this.priorityUp.f_93624_ = false;
        this.priorityDown.f_93624_ = false;
        this.delete.f_93624_ = false;
    }

    public void showButtons(WidgetEditorWidget<?> widget) {
        this.config.m_264152_(widget.m_252754_() - 1, widget.m_252907_() - 7);
        this.config.f_93624_ = true;
        this.priorityUp.m_264152_(widget.m_252754_() + 5, widget.m_252907_() - 7);
        this.priorityUp.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.priorityUp").m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"custommachinery.gui.creation.gui.priority.value", (Object[])new Object[]{widget.properties.getPriority()}).m_130940_(ChatFormatting.GRAY))));
        this.priorityUp.f_93624_ = true;
        this.priorityDown.m_264152_(widget.m_252754_() + 11, widget.m_252907_() - 7);
        this.priorityDown.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.priorityDown").m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"custommachinery.gui.creation.gui.priority.value", (Object[])new Object[]{widget.properties.getPriority()}).m_130940_(ChatFormatting.GRAY))));
        this.priorityDown.f_93624_ = true;
        this.delete.m_264152_(widget.m_252754_() + 17, widget.m_252907_() - 7);
        this.delete.f_93624_ = true;
    }

    public <T extends IGuiElement> void config(WidgetEditorWidget<T> widget) {
        this.parent.openPopup(widget.builder.makeConfigPopup(this.parent, widget.properties, (IGuiElement)widget.widget.getElement(), widget::refreshWidget));
    }

    private void changePriority(int delta) {
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)guiEventListener;
            widget.properties.setPriority(widget.properties.getPriority() + delta);
            widget.refreshWidget(null);
            List<WidgetEditorWidget> sorted = this.widgets.stream().sorted(Comparator.comparingInt(w -> w.properties.getPriority())).toList();
            this.widgets.clear();
            this.widgets.addAll(sorted);
            this.priorityUp.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.priorityUp").m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"custommachinery.gui.creation.gui.priority.value", (Object[])new Object[]{widget.properties.getPriority()}).m_130940_(ChatFormatting.GRAY))));
            this.priorityDown.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.priorityDown").m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"custommachinery.gui.creation.gui.priority.value", (Object[])new Object[]{widget.properties.getPriority()}).m_130940_(ChatFormatting.GRAY))));
            this.parent.setChanged();
        }
    }

    private void delete() {
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)guiEventListener;
            ConfirmPopup popup = new ConfirmPopup(this.parent, 128, 96, () -> {
                this.widgets.remove((Object)widget);
                this.m_7522_(null);
                this.parent.getBuilder().getGuiElements().remove(widget.widget.getElement());
                this.parent.setChanged();
            });
            popup.title((Component)Component.m_237115_((String)"custommachinery.gui.popup.warning").m_130940_(ChatFormatting.DARK_RED));
            popup.text(new Component[]{Component.m_237115_((String)"custommachinery.gui.creation.gui.delete.popup")});
            this.parent.openPopup(popup);
        }
    }

    private <T extends IGuiElement> WidgetEditorWidget<T> getWidget(T element) {
        AbstractGuiElementWidget<? extends IGuiElement> widget = GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get(element, this.dummyScreen);
        IGuiElementBuilder<? extends IGuiElement> builder = GuiElementBuilderRegistry.getBuilder(element.getType());
        return new WidgetEditorWidget<IGuiElement>(widget, builder);
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(this.m_252754_() - 2, this.m_252907_() - 2, this.m_252754_() + this.m_5711_() + 2, this.m_252907_() + this.m_93694_() + 2, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)0));
        graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), FastColor.ARGB32.m_13660_((int)255, (int)198, (int)198, (int)198));
        graphics.m_280168_().m_85836_();
        this.widgets.forEach(widget -> widget.m_88315_(graphics, mouseX, mouseY, partialTick));
        graphics.m_280168_().m_85849_();
        this.config.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.priorityUp.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.priorityDown.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.delete.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public void m_252865_(int x) {
        super.m_252865_(x);
        this.widgets.forEach(widget -> widget.m_252865_(x + widget.widget.getElement().getX()));
    }

    public void m_253211_(int y) {
        super.m_253211_(y);
        this.widgets.forEach(widget -> widget.m_253211_(y + widget.widget.getElement().getY()));
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public void m_7897_(boolean isDragging) {
        this.dragging = isDragging;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.focused;
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        if (this.focused != null) {
            this.focused.m_93692_(false);
        }
        this.focused = focused;
        if (focused != null) {
            focused.m_93692_(true);
        }
        if (focused instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)focused;
            this.showButtons(widget);
        } else {
            this.hideButtons();
        }
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_5953_(mouseX, mouseY)) continue;
            return Optional.of(guiEventListener);
        }
        return Optional.empty();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.config.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.priorityUp.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.priorityDown.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.delete.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
            this.m_7522_(guiEventListener);
            if (button == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        this.m_7522_(null);
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.m_7897_(false);
        return this.m_7222_() != null && this.m_7222_().m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.m_7222_() != null && this.m_7282_() && button == 0) {
            return this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.m_94729_(mouseX, mouseY).filter(arg -> arg.m_6050_(mouseX, mouseY, delta)).isPresent();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.m_7222_() != null && this.m_7222_().m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.m_7222_() != null && this.m_7222_().m_5534_(codePoint, modifiers);
    }

    private class DummyScreen
    implements IMachineScreen {
        private final MachineTile dummy = PlatformHelper.createMachineTile(BlockPos.f_121853_, ((CustomMachineBlock)((Object)Registration.CUSTOM_MACHINE_BLOCK.get())).m_49966_());

        private DummyScreen() {
        }

        @Override
        public int getX() {
            return GuiEditorWidget.this.m_252754_();
        }

        @Override
        public int getY() {
            return GuiEditorWidget.this.m_252907_();
        }

        @Override
        public int getWidth() {
            return GuiEditorWidget.this.m_5711_();
        }

        @Override
        public int getHeight() {
            return GuiEditorWidget.this.m_93694_();
        }

        @Override
        public MachineTile getTile() {
            return this.dummy;
        }

        @Override
        public ICustomMachine getMachine() {
            return this.dummy.getMachine();
        }
    }

    public class WidgetEditorWidget<T extends IGuiElement>
    extends AbstractWidget {
        private final IGuiElementBuilder<T> builder;
        private final MutableProperties properties;
        private AbstractGuiElementWidget<T> widget;
        private DragType dragType;
        private double dragX;
        private double dragY;

        public WidgetEditorWidget(AbstractGuiElementWidget<T> widget, IGuiElementBuilder<T> builder) {
            super(widget.m_252754_(), widget.m_252907_(), widget.m_5711_(), widget.m_93694_(), widget.m_6035_());
            this.dragType = DragType.DEFAULT;
            this.dragX = 0.0;
            this.dragY = 0.0;
            this.widget = widget;
            this.builder = builder;
            this.properties = new MutableProperties(widget.getElement().getProperties());
        }

        public void refreshWidget(@Nullable T from) {
            T element = this.widget.getElement();
            T newElement = from != null ? from : this.builder.make(this.properties.build(), element);
            this.widget = GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get((IGuiElement)newElement, GuiEditorWidget.this.dummyScreen);
            this.widget.m_264152_(this.m_252754_(), this.m_252907_());
            this.f_93618_ = this.widget.m_5711_();
            this.f_93619_ = this.widget.m_93694_();
            GuiEditorWidget.this.parent.getBuilder().getGuiElements().remove(element);
            GuiEditorWidget.this.parent.getBuilder().getGuiElements().add((IGuiElement)newElement);
        }

        private DragType getDragType(double mouseX, double mouseY) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return DragType.DEFAULT;
            }
            if (mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + 1) && mouseY >= (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + this.m_93694_())) {
                return DragType.LEFT_RESIZE;
            }
            if (mouseX >= (double)(this.m_252754_() + this.m_5711_() - 1) && mouseX <= (double)(this.m_252754_() + this.m_5711_()) && mouseY >= (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + this.m_93694_())) {
                return DragType.RIGHT_RESIZE;
            }
            if (mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.m_5711_()) && mouseY >= (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + 1)) {
                return DragType.UP_RESIZE;
            }
            if (mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.m_5711_()) && mouseY >= (double)(this.m_252907_() + this.m_93694_() - 1) && mouseY <= (double)(this.m_252907_() + this.m_93694_())) {
                return DragType.DOWN_RESIZE;
            }
            return DragType.DEFAULT;
        }

        private void checkCursorShape(int mouseX, int mouseY) {
            if (this.dragType != DragType.DEFAULT) {
                return;
            }
            switch (this.getDragType(mouseX, mouseY)) {
                case LEFT_RESIZE: 
                case RIGHT_RESIZE: {
                    GLFW.glfwSetCursor((long)Minecraft.m_91087_().m_91268_().m_85439_(), (long)GLFW.glfwCreateStandardCursor((int)221189));
                    break;
                }
                case UP_RESIZE: 
                case DOWN_RESIZE: {
                    GLFW.glfwSetCursor((long)Minecraft.m_91087_().m_91268_().m_85439_(), (long)GLFW.glfwCreateStandardCursor((int)221190));
                    break;
                }
                default: {
                    GLFW.glfwSetCursor((long)Minecraft.m_91087_().m_91268_().m_85439_(), (long)GLFW.glfwCreateStandardCursor((int)208897));
                }
            }
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.m_280168_().m_85836_();
            switch (this.dragType) {
                case DEFAULT: {
                    graphics.m_280168_().m_85837_(this.dragX, this.dragY, 0.0);
                    break;
                }
                case LEFT_RESIZE: {
                    graphics.m_280168_().m_85837_((double)(-this.m_252754_()) * -this.dragX / (double)this.m_5711_() + this.dragX, 0.0, 0.0);
                    graphics.m_280168_().m_85841_((float)(-this.dragX / (double)this.m_5711_()) + 1.0f, 1.0f, 1.0f);
                    break;
                }
                case RIGHT_RESIZE: {
                    graphics.m_280168_().m_85837_((double)(-this.m_252754_()) * this.dragX / (double)this.m_5711_(), 0.0, 0.0);
                    graphics.m_280168_().m_85841_((float)(this.dragX / (double)this.m_5711_()) + 1.0f, 1.0f, 1.0f);
                    break;
                }
                case UP_RESIZE: {
                    graphics.m_280168_().m_85837_(0.0, (double)(-this.m_252907_()) * -this.dragY / (double)this.m_93694_() + this.dragY, 0.0);
                    graphics.m_280168_().m_85841_(1.0f, (float)(-this.dragY / (double)this.m_93694_()) + 1.0f, 1.0f);
                    break;
                }
                case DOWN_RESIZE: {
                    graphics.m_280168_().m_85837_(0.0, (double)(-this.m_252907_()) * this.dragY / (double)this.m_93694_(), 0.0);
                    graphics.m_280168_().m_85841_(1.0f, (float)(this.dragY / (double)this.m_93694_()) + 1.0f, 1.0f);
                }
            }
            if (this.m_93696_()) {
                graphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.m_5711_() + 1, this.m_252907_() + this.m_93694_() + 1, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0));
                graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), FastColor.ARGB32.m_13660_((int)255, (int)198, (int)198, (int)198));
                this.checkCursorShape(mouseX, mouseY);
            }
            this.widget.m_88315_(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTick);
            graphics.m_280168_().m_85849_();
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }

        public void m_252865_(int x) {
            super.m_252865_(x);
            this.properties.setX(x - GuiEditorWidget.this.m_252754_());
            this.refreshWidget(null);
        }

        public void m_253211_(int y) {
            super.m_253211_(y);
            this.properties.setY(y - GuiEditorWidget.this.m_252907_());
            this.refreshWidget(null);
        }

        public void m_93674_(int width) {
            super.m_93674_(width);
            this.properties.setWidth(width);
            this.refreshWidget(null);
        }

        public void setHeight(int height) {
            this.f_93619_ = height;
            this.properties.setHeight(height);
            this.refreshWidget(null);
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.dragType = this.getDragType(mouseX, mouseY);
        }

        protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
            GuiEditorWidget.this.hideButtons();
            switch (this.dragType) {
                case LEFT_RESIZE: 
                case UP_RESIZE: 
                case DEFAULT: {
                    this.dragX = Mth.m_14008_((double)(this.dragX + dragX), (double)(GuiEditorWidget.this.m_252754_() - this.m_252754_()), (double)(GuiEditorWidget.this.m_252754_() + GuiEditorWidget.this.m_5711_() - this.m_252754_() - this.m_5711_()));
                    this.dragY = Mth.m_14008_((double)(this.dragY + dragY), (double)(GuiEditorWidget.this.m_252907_() - this.m_252907_()), (double)(GuiEditorWidget.this.m_252907_() + GuiEditorWidget.this.m_93694_() - this.m_252907_() - this.m_93694_()));
                    break;
                }
                case RIGHT_RESIZE: {
                    this.dragX = Mth.m_14008_((double)(this.dragX + dragX), (double)(-this.m_5711_()), (double)(GuiEditorWidget.this.m_252754_() + GuiEditorWidget.this.m_5711_() - this.m_252754_() - this.m_5711_()));
                    break;
                }
                case DOWN_RESIZE: {
                    this.dragY = Mth.m_14008_((double)(this.dragY + dragY), (double)(-this.m_93694_()), (double)(GuiEditorWidget.this.m_252907_() + GuiEditorWidget.this.m_93694_() - this.m_252907_() - this.m_93694_()));
                }
            }
        }

        public void m_7691_(double mouseX, double mouseY) {
            if (this.dragX == 0.0 && this.dragY == 0.0) {
                return;
            }
            switch (this.dragType) {
                case DEFAULT: {
                    this.m_252865_(this.m_252754_() + (int)this.dragX);
                    this.m_253211_(this.m_252907_() + (int)this.dragY);
                    break;
                }
                case LEFT_RESIZE: {
                    this.m_252865_(this.m_252754_() + (int)this.dragX);
                    this.m_93674_(this.m_5711_() - (int)this.dragX);
                    break;
                }
                case RIGHT_RESIZE: {
                    this.m_93674_(this.m_5711_() + (int)this.dragX);
                    break;
                }
                case UP_RESIZE: {
                    this.m_253211_(this.m_252907_() + (int)this.dragY);
                    this.setHeight(this.m_93694_() - (int)this.dragY);
                    break;
                }
                case DOWN_RESIZE: {
                    this.setHeight(this.m_93694_() + (int)this.dragY);
                }
            }
            GuiEditorWidget.this.showButtons(this);
            GuiEditorWidget.this.parent.setChanged();
            this.dragType = DragType.DEFAULT;
            this.dragX = 0.0;
            this.dragY = 0.0;
            GLFW.glfwSetCursor((long)Minecraft.m_91087_().m_91268_().m_85439_(), (long)GLFW.glfwCreateStandardCursor((int)208897));
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            int move = Screen.m_96638_() ? 5 : (Screen.m_96637_() ? 10 : 1);
            return switch (keyCode) {
                case 263 -> {
                    this.m_252865_(Math.max(this.m_252754_() - move, GuiEditorWidget.this.m_252754_()));
                    yield true;
                }
                case 262 -> {
                    this.m_252865_(Math.min(this.m_252754_() + move, GuiEditorWidget.this.m_252754_() + GuiEditorWidget.this.m_5711_()));
                    yield true;
                }
                case 265 -> {
                    this.m_253211_(Math.max(this.m_252907_() - move, GuiEditorWidget.this.m_252907_()));
                    yield true;
                }
                case 264 -> {
                    this.m_253211_(Math.min(this.m_252907_() + move, GuiEditorWidget.this.m_252907_() + GuiEditorWidget.this.m_93694_()));
                    yield true;
                }
                case 261 -> {
                    GuiEditorWidget.this.delete();
                    yield true;
                }
                default -> false;
            };
        }
    }

    private static enum DragType {
        DEFAULT,
        UP_RESIZE,
        DOWN_RESIZE,
        LEFT_RESIZE,
        RIGHT_RESIZE;

    }
}

