/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.SuggestedEditBox;
import fr.frinn.custommachinery.common.guielement.BackgroundGuiElement;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BackgroundEditorPopup
extends PopupScreen {
    @Nullable
    private final BackgroundGuiElement background;
    private CycleButton<Mode> mode;
    private SuggestedEditBox texture;

    public BackgroundEditorPopup(MachineEditScreen parent) {
        super(parent, 256, 128);
        this.background = parent.getBuilder().getGuiElements().stream().filter(element -> element instanceof BackgroundGuiElement).map(element -> (BackgroundGuiElement)element).findFirst().orElse(null);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        Mode mode = Mode.CUSTOM;
        if (this.background == null || this.background.getTexture() == null) {
            mode = Mode.NO_BACKGROUND;
        } else if (this.background.getTexture().equals((Object)BackgroundGuiElement.BASE_BACKGROUND)) {
            mode = Mode.DEFAULT;
        }
        GridLayout layout = new GridLayout(this.x + 5, this.y + 5).m_267612_(5);
        GridLayout.RowHelper row = layout.m_264606_(2);
        LayoutSettings center = row.m_264551_().m_264356_();
        Objects.requireNonNull(this.f_96547_);
        row.m_264276_((LayoutElement)new StringWidget(this.xSize - 10, 9, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background"), this.f_96547_), 2, center);
        row.m_264139_((LayoutElement)new StringWidget((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background.mode"), this.f_96547_));
        this.mode = (CycleButton)row.m_264139_((LayoutElement)CycleButton.m_168894_(Mode::title).m_168929_().m_168961_((Object[])Mode.values()).m_168948_((Object)mode).m_168936_(0, 0, 100, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background.mode"), (button, value) -> this.texture.m_94186_(value == Mode.CUSTOM)));
        row.m_264139_((LayoutElement)new StringWidget((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background.texture"), this.f_96547_));
        this.texture = (SuggestedEditBox)row.m_264139_((LayoutElement)new SuggestedEditBox(this.f_96547_, 0, 0, 100, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background.texture"), 5));
        this.texture.m_94199_(Integer.MAX_VALUE);
        if (this.background != null) {
            this.texture.m_94144_(this.background.getTexture().toString());
            this.texture.hideSuggestions();
        }
        this.texture.addSuggestions(Minecraft.m_91087_().m_91098_().m_214159_("textures", id -> true).keySet().stream().map(ResourceLocation::toString).toList());
        this.texture.m_94186_(mode == Mode.CUSTOM);
        row.m_264276_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background.close"), button -> this.close()).m_253046_(50, 20).m_253136_(), 2, center);
        layout.m_264036_();
        layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.ySize = layout.m_93694_() + 10;
    }

    private void close() {
        this.parent.closePopup(this);
    }

    @Override
    public void closed() {
        ResourceLocation texture;
        BaseScreen baseScreen = this.parent;
        if (!(baseScreen instanceof MachineEditScreen)) {
            return;
        }
        MachineEditScreen editScreen = (MachineEditScreen)baseScreen;
        if (this.mode.m_168883_() == Mode.NO_BACKGROUND) {
            if (this.background != null) {
                editScreen.getBuilder().getGuiElements().remove(this.background);
            }
            return;
        }
        switch ((Mode)((Object)this.mode.m_168883_())) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEFAULT: {
                ResourceLocation resourceLocation = BackgroundGuiElement.BASE_BACKGROUND;
                break;
            }
            case CUSTOM: {
                ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)this.texture.m_94155_());
                break;
            }
            case NO_BACKGROUND: {
                ResourceLocation resourceLocation = texture = null;
            }
        }
        if (this.background != null) {
            editScreen.getBuilder().getGuiElements().remove(this.background);
            editScreen.getBuilder().getGuiElements().add(new BackgroundGuiElement(texture, this.background.getWidth(), this.background.getHeight()));
        } else {
            editScreen.getBuilder().getGuiElements().add(new BackgroundGuiElement(texture, -1, -1));
        }
    }

    public static enum Mode {
        DEFAULT((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background.default")),
        NO_BACKGROUND((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background.disabled")),
        CUSTOM((Component)Component.m_237115_((String)"custommachinery.gui.creation.gui.background.custom"));

        private final Component title;

        private Mode(Component title) {
            this.title = title;
        }

        public Component title() {
            return this.title;
        }
    }
}

