/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component.builder;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class FluidComponentBuilder
implements IMachineComponentBuilder<FluidMachineComponent, FluidMachineComponent.Template> {
    @Override
    public MachineComponentType<FluidMachineComponent> type() {
        return (MachineComponentType)Registration.FLUID_MACHINE_COMPONENT.get();
    }

    @Override
    public PopupScreen makePopup(MachineEditScreen parent, @Nullable FluidMachineComponent.Template template, Consumer<FluidMachineComponent.Template> onFinish) {
        return new FluidComponentBuilderPopup((BaseScreen)parent, template, onFinish);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, int width, int height, FluidMachineComponent.Template template) {
        graphics.m_280203_(Items.f_42447_.m_7968_(), x, y + height / 2 - 8);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, "type: " + template.getType().getId().m_135815_(), x + 25, y + 5, 0, false);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, "id: \"" + template.getId() + "\"", x + 25, y + 15, FastColor.ARGB32.m_13660_((int)255, (int)128, (int)0, (int)0), false);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, "mode: " + template.mode(), x + 25, y + 25, FastColor.ARGB32.m_13660_((int)255, (int)0, (int)0, (int)128), false);
    }

    public static class FluidComponentBuilderPopup
    extends ComponentBuilderPopup<FluidMachineComponent.Template> {
        private EditBox id;
        private CycleButton<ComponentIOMode> mode;
        private EditBox capacity;
        private EditBox maxInput;
        private EditBox maxOutput;
        private Checkbox unique;

        public FluidComponentBuilderPopup(BaseScreen parent, @Nullable FluidMachineComponent.Template template, Consumer<FluidMachineComponent.Template> onFinish) {
            super(parent, template, onFinish, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.fluid.title"));
        }

        @Override
        public FluidMachineComponent.Template makeTemplate() {
            return new FluidMachineComponent.Template(this.id.m_94155_(), this.parseLong(this.capacity.m_94155_()), this.parseLong(this.maxInput.m_94155_()), this.parseLong(this.maxOutput.m_94155_()), Collections.emptyList(), false, (ComponentIOMode)((Object)this.mode.m_168883_()), ((ComponentIOMode)((Object)this.mode.m_168883_())).getBaseConfig(), this.unique.m_93840_());
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.id = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.id"), new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 180, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.id")));
            this.baseTemplate().ifPresentOrElse(template -> this.id.m_94144_(template.getId()), () -> this.id.m_94144_("input"));
            this.id.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.id.tooltip")));
            this.mode = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.mode"), CycleButton.m_168894_(ComponentIOMode::toComponent).m_168929_().m_168961_((Object[])ComponentIOMode.values()).m_168948_((Object)ComponentIOMode.BOTH).m_168930_(0, 0, 180, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.mode")));
            this.baseTemplate().ifPresent(template -> this.mode.m_168892_((Object)template.mode()));
            this.capacity = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.capacity"), new EditBox(this.f_96547_, 0, 0, 180, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.capacity")));
            this.capacity.m_94153_(this::checkLong);
            this.baseTemplate().ifPresentOrElse(template -> this.capacity.m_94144_("" + template.capacity()), () -> this.capacity.m_94144_("10000"));
            this.maxInput = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.maxInput"), new EditBox(this.f_96547_, 0, 0, 180, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.maxInput")));
            this.maxInput.m_94153_(this::checkLong);
            this.baseTemplate().ifPresentOrElse(template -> this.maxInput.m_94144_("" + template.maxInput()), () -> this.maxInput.m_94144_("10000"));
            this.maxOutput = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.maxOutput"), new EditBox(this.f_96547_, 0, 0, 180, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.maxOutput")));
            this.maxOutput.m_94153_(this::checkLong);
            this.baseTemplate().ifPresentOrElse(template -> this.maxOutput.m_94144_("" + template.maxOutput()), () -> this.maxOutput.m_94144_("10000"));
            this.unique = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.fluid.unique"), new Checkbox(0, 0, 20, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.fluid.unique"), false));
            if (this.baseTemplate().map(FluidMachineComponent.Template::unique).orElse(false).booleanValue() != this.unique.m_93840_()) {
                this.unique.m_5691_();
            }
        }
    }
}

