/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component.builder;

import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.common.component.ExperienceMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class ExperienceComponentBuilder
implements IMachineComponentBuilder<ExperienceMachineComponent, ExperienceMachineComponent.Template> {
    @Override
    public MachineComponentType<ExperienceMachineComponent> type() {
        return (MachineComponentType)Registration.EXPERIENCE_MACHINE_COMPONENT.get();
    }

    @Override
    public PopupScreen makePopup(MachineEditScreen parent, @Nullable ExperienceMachineComponent.Template template, Consumer<ExperienceMachineComponent.Template> onFinish) {
        return new ExperienceComponentBuilderPopup((BaseScreen)parent, template, onFinish);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, int width, int height, ExperienceMachineComponent.Template template) {
        graphics.m_280203_(Items.f_42612_.m_7968_(), x, y + height / 2 - 8);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, "type: " + template.getType().getId().m_135815_(), x + 25, y + 5, 0, false);
    }

    public static class ExperienceComponentBuilderPopup
    extends ComponentBuilderPopup<ExperienceMachineComponent.Template> {
        private EditBox capacity;
        private Checkbox retrieve;
        private EditBox slots;

        public ExperienceComponentBuilderPopup(BaseScreen parent, @Nullable ExperienceMachineComponent.Template template, Consumer<ExperienceMachineComponent.Template> onFinish) {
            super(parent, template, onFinish, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.experience.title"));
        }

        @Override
        public ExperienceMachineComponent.Template makeTemplate() {
            return new ExperienceMachineComponent.Template((int)this.parseLong(this.capacity.m_94155_()), this.retrieve.m_93840_(), this.slotsFromString(this.slots.m_94155_()));
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.capacity = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.capacity"), new EditBox(this.f_96547_, 0, 0, 160, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.capacity")));
            this.capacity.m_94153_(this::checkLong);
            this.capacity.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.experience.capacity.tooltip")));
            this.baseTemplate().ifPresentOrElse(template -> this.capacity.m_94144_("" + template.capacity()), () -> this.capacity.m_94144_("10000"));
            this.retrieve = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.experience.retrieve"), new Checkbox(0, 0, 20, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.experience.retrieve"), false, false));
            this.retrieve.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.experience.retrieve.tooltip")));
            if (this.baseTemplate().map(ExperienceMachineComponent.Template::retrieve).orElse(false).booleanValue() != this.retrieve.m_93840_()) {
                this.retrieve.m_5691_();
            }
            this.slots = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.experience.slots"), new EditBox(this.f_96547_, 0, 0, 160, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.experience.slots")));
            this.slots.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.experience.slots.tooltip")));
            this.baseTemplate().ifPresent(template -> this.slots.m_94144_(this.stringFromSlots(template.slots())));
        }

        private List<String> slotsFromString(String s) {
            return Arrays.asList(s.split(","));
        }

        private String stringFromSlots(List<String> s) {
            StringBuilder builder = new StringBuilder();
            Iterator<String> iterator = s.iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            return builder.toString();
        }
    }
}

