/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component.builder;

import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class EnergyComponentBuilder
implements IMachineComponentBuilder<EnergyMachineComponent, EnergyMachineComponent.Template> {
    @Override
    public MachineComponentType<EnergyMachineComponent> type() {
        return (MachineComponentType)Registration.ENERGY_MACHINE_COMPONENT.get();
    }

    @Override
    public PopupScreen makePopup(MachineEditScreen parent, @Nullable EnergyMachineComponent.Template template, Consumer<EnergyMachineComponent.Template> onFinish) {
        return new EnergyComponentBuilderPopup((BaseScreen)parent, template, onFinish);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, int width, int height, EnergyMachineComponent.Template template) {
        graphics.m_280203_(Items.f_42778_.m_7968_(), x, y + height / 2 - 8);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, "type: " + template.getType().getId().m_135815_(), x + 25, y + 5, 0, false);
    }

    public static class EnergyComponentBuilderPopup
    extends ComponentBuilderPopup<EnergyMachineComponent.Template> {
        private EditBox capacity;
        private EditBox maxInput;
        private EditBox maxOutput;

        public EnergyComponentBuilderPopup(BaseScreen parent, @Nullable EnergyMachineComponent.Template template, Consumer<EnergyMachineComponent.Template> onFinish) {
            super(parent, template, onFinish, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.energy.title"));
        }

        @Override
        public EnergyMachineComponent.Template makeTemplate() {
            return new EnergyMachineComponent.Template(this.parseLong(this.capacity.m_94155_()), this.parseLong(this.maxInput.m_94155_()), this.parseLong(this.maxOutput.m_94155_()), SideConfig.Template.DEFAULT_ALL_INPUT);
        }

        @Override
        protected void m_7856_() {
            super.m_7856_();
            this.capacity = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.capacity"), new EditBox(this.f_96547_, 0, 0, 180, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.capacity")));
            this.capacity.m_94153_(this::checkLong);
            this.baseTemplate().ifPresentOrElse(template -> this.capacity.m_94144_("" + template.capacity()), () -> this.capacity.m_94144_("10000"));
            this.maxInput = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.maxInput"), new EditBox(this.f_96547_, 0, 0, 180, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.maxInput")));
            this.maxInput.m_94153_(this::checkLong);
            this.baseTemplate().ifPresentOrElse(template -> this.maxInput.m_94144_("" + template.maxInput()), () -> this.maxInput.m_94144_("10000"));
            this.maxOutput = this.propertyList.add((Component)Component.m_237115_((String)"custommachinery.gui.creation.components.maxOutput"), new EditBox(this.f_96547_, 0, 0, 180, 20, (Component)Component.m_237115_((String)"custommachinery.gui.creation.components.maxOutput")));
            this.maxOutput.m_94153_(this::checkLong);
            this.baseTemplate().ifPresentOrElse(template -> this.maxOutput.m_94144_("" + template.maxOutput()), () -> this.maxOutput.m_94144_("10000"));
        }
    }
}

