/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.creation.component.MachineComponentBuilderRegistry;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.ListWidget;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ComponentCreationPopup
extends PopupScreen {
    public static final Component CONFIRM = Component.m_237115_((String)"custommachinery.gui.popup.confirm").m_130940_(ChatFormatting.GREEN);
    public static final Component CANCEL = Component.m_237115_((String)"custommachinery.gui.popup.cancel").m_130940_(ChatFormatting.RED);
    private final Runnable onChange;
    private ComponentCreationListWidget list;

    public ComponentCreationPopup(MachineEditScreen parent, Runnable onChange) {
        super(parent, 116, 144);
        this.onChange = onChange;
    }

    private void confirm() {
        BaseScreen baseScreen;
        ComponentCreationListWidget.ComponentCreationListEntry entry = (ComponentCreationListWidget.ComponentCreationListEntry)this.list.getSelected();
        if (entry != null && (baseScreen = this.parent) instanceof MachineEditScreen) {
            MachineEditScreen editScreen = (MachineEditScreen)baseScreen;
            PopupScreen componentCreationPopup = entry.builder.makePopup(editScreen, null, template -> {
                editScreen.getBuilder().getComponents().add((IMachineComponentTemplate<?>)template);
                editScreen.setChanged();
                this.onChange.run();
            });
            editScreen.closePopup(this);
            editScreen.openPopup(componentCreationPopup);
        }
    }

    private void cancel() {
        this.parent.closePopup(this);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        MutableComponent title = Component.m_237115_((String)"custommachinery.gui.creation.components.create.title");
        Objects.requireNonNull(this.f_96547_);
        this.m_142416_((GuiEventListener)new StringWidget(this.x, this.y + 5, this.xSize, 9, (Component)title, Minecraft.m_91087_().f_91062_));
        this.list = (ComponentCreationListWidget)this.m_142416_((GuiEventListener)new ComponentCreationListWidget(this.x + 3, this.y + 15, this.xSize - 10, this.ySize - 50));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CONFIRM, b -> this.confirm()).m_252987_(this.x + 5, this.y + this.ySize - 30, 50, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CANCEL, b -> this.cancel()).m_252987_(this.x + this.xSize - 55, this.y + this.ySize - 30, 50, 20).m_253136_());
    }

    protected static class ComponentCreationListWidget
    extends ListWidget<ComponentCreationListEntry> {
        public ComponentCreationListWidget(int x, int y, int width, int height) {
            super(x, y, width, height, 20, (Component)Component.m_237119_());
            this.setRenderSelection();
            for (MachineComponentType type : Registration.MACHINE_COMPONENT_TYPE_REGISTRY) {
                IMachineComponentBuilder builder = MachineComponentBuilderRegistry.getBuilder(type);
                if (builder == null) continue;
                this.addEntry(new ComponentCreationListEntry(builder));
            }
            this.setSelected(this.getEntries().isEmpty() ? null : (ComponentCreationListEntry)this.getEntries().get(0));
        }

        protected static class ComponentCreationListEntry
        extends ListWidget.Entry {
            private final IMachineComponentBuilder<?, ?> builder;

            private ComponentCreationListEntry(IMachineComponentBuilder<?, ?> builder) {
                this.builder = builder;
            }

            @Override
            public void render(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
                graphics.m_280614_(Minecraft.m_91087_().f_91062_, this.builder.type().getTranslatedName(), x + 5, y + 5, 0, false);
            }

            public List<? extends GuiEventListener> m_6702_() {
                return Collections.emptyList();
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return true;
            }
        }
    }
}

